/********************************************************************************
*                                                                               *
*                   O p e n G L   S h a p e   O b j e c t                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXGLShape.h,v 1.2 1999/09/20 22:12:56 jeroen Exp $                       *
********************************************************************************/
#ifndef FXGLSHAPE_H
#define FXGLSHAPE_H

class FXGLViewer;
class FXGLObject;


// Shape drawing options
enum FXShapeOptions {
  SURFACE_SINGLESIDED   = 0,              // Single-sided [both sides same]
  SURFACE_DUALSIDED     = 0x00000001,     // Dual-sided surface
  SHADING_NONE          = 0,              // No light source
  SHADING_SMOOTH        = 0x00000002,     // Smooth shaded
  SHADING_FLAT          = 0x00000004,     // Flag shaded
  FACECULLING_OFF       = 0,              // No face culling
  FACECULLING_ON        = 0x00000008,     // Cull backward facing surfaces
  STYLE_SURFACE         = 0x00000010,     // Draw filled surfaces
  STYLE_WIREFRAME       = 0x00000020,     // Draw wire frame
  STYLE_POINTS          = 0x00000040,     // Draw as points
  STYLE_BOUNDBOX        = 0x00000080      // Draw bounding box
  };
  
  
  
class FXAPI FXGLShape : public FXGLObject {
  FXDECLARE(FXGLShape)
protected:
  FXVec		position;	      // Middle of the Bounding Box
  FXMaterial    material[2];          // Front and back material properties
  FXRange       range;                // Range box
  FXuint	options;              // Drawing options
  FXString	tip;
protected:
  FXGLShape();
  virtual void drawshape(FXGLViewer*){}  // To be overloaded by derived class
  void drawbox();
  void drawhandles();
public:
  long onDNDDrop(FXObject*,FXSelector,void*);
  long onDNDMotion(FXObject*,FXSelector,void*);
  long onQueryTip(FXObject*,FXSelector,void*);
  long onCmdShadeOff(FXObject*,FXSelector,void*);
  long onUpdShadeOff(FXObject*,FXSelector,void*);
  long onCmdShadeOn(FXObject*,FXSelector,void*);
  long onUpdShadeOn(FXObject*,FXSelector,void*);
  long onCmdShadeSmooth(FXObject*,FXSelector,void*);
  long onUpdShadeSmooth(FXObject*,FXSelector,void*);
  long onCmdFrontMaterial(FXObject*,FXSelector,void*);
  long onUpdFrontMaterial(FXObject*,FXSelector,void*);
  long onCmdBackMaterial(FXObject*,FXSelector,void*);
  long onUpdBackMaterial(FXObject*,FXSelector,void*);
  long onCmdDrawingStyle(FXObject*,FXSelector,void*);
  long onUpdDrawingStyle(FXObject*,FXSelector,void*);
public:
  enum {
    ID_SHADEOFF=FXGLObject::ID_LAST,
    ID_SHADEON,
    ID_SHADESMOOTH,
    ID_TOGGLE_SIDED,
    ID_TOGGLE_CULLING,
    ID_STYLE_POINTS,
    ID_STYLE_WIREFRAME,
    ID_STYLE_SURFACE,
    ID_STYLE_BOUNDINGBOX,
    ID_FRONT_MATERIAL,
    ID_BACK_MATERIAL,
    ID_LAST
    };
public:
  FXGLShape(FXfloat x,FXfloat y,FXfloat z,FXuint opts);
  FXGLShape(FXfloat x,FXfloat y,FXfloat z,FXuint opts,const FXMaterial& front,const FXMaterial& back);
  virtual void bounds(FXRange& box);
  virtual void draw(FXGLViewer* viewer);
  virtual void hit(FXGLViewer* viewer);
  virtual FXbool canDrag() const;
  virtual FXbool canDelete() const;
  virtual FXbool drag(FXGLViewer* viewer,FXint fx,FXint fy,FXint tx,FXint ty);
  void setTipText(const FXString& text){ tip=text; }
  FXString getTipText() const { return tip; }
  void setMaterial(FXint side,const FXMaterial &mtl);
  void getMaterial(FXint side,FXMaterial &mtl) const;
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);  
  };

#endif

