/********************************************************************************
*                                                                               *
*                     M e n u   C o m m a n d   W i d g e t                     *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXMenuCommand.h,v 1.3 1999/11/04 08:21:57 jeroen Exp $                   *
********************************************************************************/
#ifndef FXMENUCOMMAND_H
#define FXMENUCOMMAND_H


// States the menu can be in
enum FXMenuState {
  MENUSTATE_NORMAL   = 0,           // Normal, unchecked state
  MENUSTATE_CHECKED  = 1,           // Checked with a checkmark
  MENUSTATE_RCHECKED = 2            // Checked with a bullit
  };
  
  
 
// Command menu item
class FXAPI FXMenuCommand : public FXMenuCaption {
  FXDECLARE(FXMenuCommand)
protected:
  FXuchar      state;       // State of menu
  FXString     accel;       // Accelerator string
  FXHotKey     acckey;      // Accelerator key
protected:
  FXMenuCommand(){}
  void drawCheck(FXDCWindow& dc,FXint x,FXint y);
  void drawBullit(FXDCWindow& dc,FXint x,FXint y);
private:
  FXMenuCommand(const FXMenuCommand&);
  FXMenuCommand &operator=(const FXMenuCommand&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onEnter(FXObject*,FXSelector,void*);
  long onLeave(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onKeyPress(FXObject*,FXSelector,void*);
  long onKeyRelease(FXObject*,FXSelector,void*);
  long onHotKeyPress(FXObject*,FXSelector,void*);
  long onHotKeyRelease(FXObject*,FXSelector,void*);
  long onCheck(FXObject*,FXSelector,void*);
  long onUncheck(FXObject*,FXSelector,void*);
public:
  FXMenuCommand(FXComposite* p,const FXString& text,FXIcon* ic=NULL,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0);
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  virtual FXbool canFocus() const;
  virtual void setFocus();
  virtual void killFocus();
  void setDefault();
  void setOther();
  FXint isDefault() const;
  void check();
  void uncheck();
  FXint isChecked() const;
  void checkRadio();
  void uncheckRadio();
  FXint isRadioChecked() const;
  void setAccelText(const FXString& text);
  FXString getAccelText() const { return accel; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXMenuCommand();
  };


#endif
