/********************************************************************************
*                                                                               *
*                           T e x t F i e l d   W i d g e t                     *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXTextField.h,v 1.6 1999/11/09 23:58:38 jeroen Exp $                     *
********************************************************************************/
#ifndef FXTEXTFIELD_H
#define FXTEXTFIELD_H


// Textfield styles
enum FXTextFieldStyle {
  TEXTFIELD_PASSWD   = 0x00800000,        // Password mode
  TEXTFIELD_INTEGER  = 0x01000000,        // Integer mode
  TEXTFIELD_REAL     = 0x02000000,        // Real mode
  TEXTFIELD_READONLY = 0x04000000         // NOT editable
  };
  


class FXAPI FXTextField : public FXFrame {
  FXDECLARE(FXTextField)
protected:
  FXString     contents;                  // Edited text
  FXFont      *font;                      // Text font
  FXColor      textColor;                 // Text color
  FXColor      selbackColor;              // Selected background color
  FXColor      seltextColor;              // Selected text color
  FXint        cursor;                    // Cursor position
  FXint        anchor;                    // Anchor position
  FXTimer     *blinker;                   // Blink timer
  FXint        columns;                   // Number of columns visible
  FXint        scroll;                    // Scolled amount
  FXString     clipped;                   // Clipped text
  FXString     help;                      // Help string
  FXString     tip;                       // Tooltip
protected:
  FXTextField();
  FXint index(FXint x);
  FXint coord(FXint i);
  virtual void layout();
  void drawCursor(FXuint state);
  void drawTextRange(FXDCWindow& dc,FXint fm,FXint to);
  void drawTextFragment(FXDCWindow& dc,FXint x,FXint y,FXint fm,FXint to);
  void drawPWDTextFragment(FXDCWindow& dc,FXint x,FXint y,FXint fm,FXint to);
private:
  FXTextField(const FXTextField&);
  FXTextField& operator=(const FXTextField&);
public:
  long onPaint(FXObject*,FXSelector,void*);
  long onKeyPress(FXObject*,FXSelector,void*);
  long onKeyRelease(FXObject*,FXSelector,void*);
  long onLeftBtnPress(FXObject*,FXSelector,void*);
  long onLeftBtnRelease(FXObject*,FXSelector,void*);
  long onMiddleBtnPress(FXObject*,FXSelector,void*);
  long onMiddleBtnRelease(FXObject*,FXSelector,void*);
  long onRightBtnPress(FXObject*,FXSelector,void*);
  long onRightBtnRelease(FXObject*,FXSelector,void*);
  long onChanged(FXObject*,FXSelector,void*);
  long onCommand(FXObject*,FXSelector,void*);
  long onMotion(FXObject*,FXSelector,void*);
  long onSelectionLost(FXObject*,FXSelector,void*);
  long onSelectionGained(FXObject*,FXSelector,void*);
  long onSelectionRequest(FXObject*,FXSelector,void* ptr);
  long onClipboardLost(FXObject*,FXSelector,void*);
  long onClipboardGained(FXObject*,FXSelector,void*);
  long onClipboardRequest(FXObject*,FXSelector,void*);
  long onFocusSelf(FXObject*,FXSelector,void*);
  long onFocusIn(FXObject*,FXSelector,void*);
  long onFocusOut(FXObject*,FXSelector,void*);
  long onBlink(FXObject*,FXSelector,void*);
  long onAutoScroll(FXObject*,FXSelector,void*);
  long onQueryHelp(FXObject*,FXSelector,void*);
  long onQueryTip(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdSetIntValue(FXObject*,FXSelector,void*);
  long onCmdSetRealValue(FXObject*,FXSelector,void*);
  long onCmdSetStringValue(FXObject*,FXSelector,void*);
  long onCmdGetIntValue(FXObject*,FXSelector,void*);
  long onCmdGetRealValue(FXObject*,FXSelector,void*);
  long onCmdGetStringValue(FXObject*,FXSelector,void*);
  long onCmdCursorHome(FXObject*,FXSelector,void*);
  long onCmdCursorEnd(FXObject*,FXSelector,void*);
  long onCmdCursorRight(FXObject*,FXSelector,void*);
  long onCmdCursorLeft(FXObject*,FXSelector,void*);
  long onCmdMark(FXObject*,FXSelector,void*);
  long onCmdExtend(FXObject*,FXSelector,void*);
  long onCmdSelectAll(FXObject*,FXSelector,void*);
  long onCmdDeselectAll(FXObject*,FXSelector,void*);
  long onCmdCutSel(FXObject*,FXSelector,void*);
  long onCmdCopySel(FXObject*,FXSelector,void*);
  long onCmdPasteSel(FXObject*,FXSelector,void*);
  long onCmdDeleteSel(FXObject*,FXSelector,void*);
  long onCmdInsertChar(FXObject*,FXSelector,void*);
  long onCmdInsertString(FXObject*,FXSelector,void*);
  long onCmdBackspace(FXObject*,FXSelector,void*);
  long onCmdDelete(FXObject*,FXSelector,void*);
  long onCmdToggleEditable(FXObject*,FXSelector,void*);
  long onUpdToggleEditable(FXObject*,FXSelector,void*);
public:
  enum{
    ID_CURSOR_HOME=FXFrame::ID_LAST,
    ID_CURSOR_END,
    ID_CURSOR_RIGHT,
    ID_CURSOR_LEFT,
    ID_MARK,
    ID_EXTEND,
    ID_SELECT_ALL,
    ID_DESELECT_ALL,
    ID_CUT_SEL,
    ID_COPY_SEL,
    ID_PASTE_SEL,
    ID_DELETE_SEL,
    ID_INSERT_CHAR,
    ID_INSERT_STRING,
    ID_BACKSPACE,
    ID_DELETE,
    ID_TOGGLE_EDITABLE,
    ID_LAST
    };
public:
  FXTextField(FXComposite* p,FXint ncols,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=FRAME_SUNKEN|FRAME_THICK,FXint x=0,FXint y=0,FXint w=0,FXint h=0,FXint pl=DEFAULT_PAD,FXint pr=DEFAULT_PAD,FXint pt=DEFAULT_PAD,FXint pb=DEFAULT_PAD);
  virtual void create();
  virtual void enable();
  virtual void disable();
  virtual FXint getDefaultWidth();
  virtual FXint getDefaultHeight();
  virtual FXbool canFocus() const;
  FXbool isEditable() const;
  void setEditable(FXbool edit=TRUE);
  void setCursorPos(FXint pos);
  FXint getCursorPos() const { return cursor; }
  void setAnchorPos(FXint pos);
  FXint getAnchorPos() const { return anchor; }
  void setText(const FXString& text);
  FXString getText() const { return contents; }
  void setFont(FXFont* fnt);
  FXFont* getFont() const { return font; }
  FXColor getTextColor() const { return textColor; }
  void setTextColor(FXColor clr);
  FXColor getSelBackColor() const { return selbackColor; }
  void setSelBackColor(FXColor clr);
  FXColor getSelTextColor() const { return seltextColor; }
  void setSelTextColor(FXColor clr);
  void setNumColumns(FXint cols);
  FXint getNumColumns() const { return columns; }
  void setJustify(FXuint mode);
  FXuint getJustify() const;
  void setHelpText(const FXString& text);
  FXString getHelpText() const { return help; }
  void setTipText(const FXString& text);
  FXString getTipText() const { return tip; }
  void setTextStyle(FXuint style);
  FXuint getTextStyle() const;
  FXbool setSelection(FXint pos,FXint len);
  FXbool extendSelection(FXint pos);
  FXbool killSelection();
  void makePositionVisible(FXint pos);
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXTextField();
  };


#endif
