/********************************************************************************
*                                                                               *
*               D e v i c e   C o n t e x t   B a s e   C l a s s               *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* Major Contributions for Windows NT by Lyle Johnson                            *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXDC.cpp,v 1.1 1999/09/14 13:41:23 jeroen Exp $                         *
********************************************************************************/
#include "xincs.h"
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXVisual.h"
#include "FXDC.h"


/*
  Notes:
  
  - This is not an abstract base class; rather, its a NULL-implementation,
    i.e. drawing commands to FXDC will go to into the bit bucket.
    
  - All functions in the DC are virtuals.

  - A DC is associated with a certain drawing surface, using:

      FXDC::begin(FXDrawable* drawable)
      
    and disassociated with:
    
      FXDC::end()
    
  - While associated with a certain surface, no other association may be made
    until after the association is broken.
    
  - One possible exception to the above rule COULD be made: repeated locks
    on the same surface might be OK; the surface should only be unlocked
    when an equal number of unlocks takes place [[[]][]]. 
      
  - One DC object is created for all windows of the same depth and other attributes.

  - We like the OpenGL model of write-only, i.e. we [typically] don't read
    back any info from the DC. [Except stuff like device characteristics].

  - We envision the following flavors of DC's:

      1) A NULL context, in which all output goes to /dev/null

      2) A Window context, in which output goes to a on- or off-screen
         window or pixmap.

      3) A printer context, in which output is rendered e.g. as PostScript.

  - Implementations of DC's for specific target devices may cache various
    things such as patterns, stipples, colors, etc, so as to optimize performance.
    
  - Since DC's may be shared between windows, you should leave the DC in the
    same state as you found it before releasing it.

  - You acquire a DC by asking the drawable surface on which you want to draw
    for a DC.  You receive a subclass of FXDC, and have no knowledge of device
    specific details, except as revealed by the basic FXDC API's.

  - After you're through with drawing, you should release the DC.
  
  - Motto: Nobody knows about any other DC that FXDC!!!  The other ones
    are implementations, not directly accessible by any but a few select
    FOX implementation files.
    
  - In FOX, a FXDC is NOT a wrapper class:- we do NOT assume the O.S. provides
    its own DC abstraction:- hence all those virtuals.
    This also means it is possible to make your own, simply by subclassing FXDC!
*/


/*******************************************************************************/

// Object implementation
FXIMPLEMENT(FXDC,FXObject,NULL,0)


// Initialize nicely
FXDC::FXDC(FXApp* a){
  if(!a){ fxerror("Application object cannot be NULL\n"); }
  app=a;
  surface=NULL;
  font=NULL;
  pattern=STIPPLE_NONE;
  stipple=NULL;
  tile=NULL;
  mask=NULL;
  fg=0;
  bg=1;
  width=0;
  cap=CAP_BUTT;
  join=JOIN_MITER;
  style=LINE_SOLID;
  fill=FILL_SOLID;
  rule=RULE_EVEN_ODD;
  rop=BLT_SRC;
  tx=0;
  ty=0;
  cx=0;
  cy=0;
  }

  
// Draw a point in the current pen color
void FXDC::drawPoint(FXint ,FXint ){ }


// Draw points in the current pen color. 
// Each point's position is relative to the drawable's origin (as usual).
void FXDC::drawPoints(const FXPoint* ,FXuint ){ }


// Draw points in the current pen color. The first point's position is
// relative to the drawable's origin, but each subsequent point's position
// is relative to the previous point's position; each FXPoint defines
// the relative coordinates. Think LOGO.
void FXDC::drawPointsRel(const FXPoint* ,FXuint ){ }


// Draw a line
void FXDC::drawLine(FXint ,FXint ,FXint ,FXint ){ }



// Draw multiple lines. All points are drawn connected.
// Each point is specified relative to Drawable's origin.
void FXDC::drawLines(const FXPoint* ,FXuint ){ }



// Draw multiple lines. All points are drawn connected.
// First point's coordinate is relative to drawable's origin, but
// subsequent points' coordinates are relative to previous point.
void FXDC::drawLinesRel(const FXPoint* ,FXuint ){ }


// Draw unconnected line segments
void FXDC::drawLineSegments(const FXSegment* ,FXuint ){ }
 

// Draw unfilled rectangle
void FXDC::drawRectangle(FXint ,FXint ,FXint ,FXint ){ }


void FXDC::drawRectangles(const FXRectangle* ,FXuint ){ }


// Draw arc
void FXDC::drawArc(FXint ,FXint ,FXint ,FXint ,FXint ,FXint ){ }


// Draw arcs
void FXDC::drawArcs(const FXArc* arcs,FXuint narcs){ }


// Filled rectangle
void FXDC::fillRectangle(FXint ,FXint ,FXint ,FXint ){ }


// Filled rectangles
void FXDC::fillRectangles(const FXRectangle* ,FXuint ){ }


// Fill arc
void FXDC::fillArc(FXint ,FXint ,FXint ,FXint ,FXint ,FXint ){ }


// Fill arcs
void FXDC::fillArcs(const FXArc* ,FXuint ){ }


// Filled simple polygon
void FXDC::fillPolygon(const FXPoint* ,FXuint ){ }


// Fill concave polygon
void FXDC::fillConcavePolygon(const FXPoint* ,FXuint ){ }


// Fill complex (self-intersecting) polygon
void FXDC::fillComplexPolygon(const FXPoint* ,FXuint ){ }


// Filled simple polygon with relative points
void FXDC::fillPolygonRel(const FXPoint* ,FXuint ){ }


// Fill concave polygon
void FXDC::fillConcavePolygonRel(const FXPoint* ,FXuint ){ }


// Fill complex (self-intersecting) polygon
void FXDC::fillComplexPolygonRel(const FXPoint* ,FXuint ){ }


// Draw string (only foreground bits)
void FXDC::drawText(FXint x,FXint y,const FXchar* ,FXuint ){ }


// Draw string (both foreground and background bits)
void FXDC::drawImageText(FXint ,FXint ,const FXchar* ,FXuint ){ }


// Draw area from source
void FXDC::drawArea(const FXDrawable* ,FXint ,FXint ,FXint ,FXint ,FXint ,FXint ){ }


// Draw image
void FXDC::drawImage(const FXImage* ,FXint ,FXint ){ }


// Draw bitmap
void FXDC::drawBitmap(const FXBitmap* ,FXint ,FXint ){ }


// Draw icon
void FXDC::drawIcon(const FXIcon*,FXint,FXint){ }


// Draw icon shaded
void FXDC::drawIconShaded(const FXIcon*,FXint,FXint){ }


// Draw hashed box
void FXDC::drawHashBox(FXint,FXint,FXint,FXint,FXint){ }


// Set foreground drawing color (brush)
void FXDC::setForeground(FXColor clr){ 
  fg=clr; 
  }


// Set background drawing color (brush)
void FXDC::setBackground(FXColor clr){ 
  bg=clr; 
  }


// Set dash pattern
void FXDC::setDashes(FXuint,const FXchar *,FXuint){ 
  }


// Set line width  
void FXDC::setLineWidth(FXuint linewidth){ 
  width=linewidth; 
  }


// Set line cap style
void FXDC::setLineCap(FXCapStyle capstyle){ 
  cap=capstyle; 
  }


// Set line join style
void FXDC::setLineJoin(FXJoinStyle joinstyle){ 
  join=joinstyle; 
  }


// Set line style
void FXDC::setLineStyle(FXLineStyle linestyle){ 
  style=linestyle; 
  }


// Set fill style
void FXDC::setFillStyle(FXFillStyle fillstyle){ 
  fill=fillstyle; 
  }
  
  
// Set fill rule
void FXDC::setFillRule(FXFillRule fillrule){ 
  rule=fillrule; 
  }


// Set blit function
void FXDC::setFunction(FXFunction func){ 
  rop=func; 
  }


// Set tile image
void FXDC::setTile(FXImage* image,FXint dx,FXint dy){ 
  tile=image; 
  tx=dx; 
  ty=dy; 
  }


// Set stipple bitmap
void FXDC::setStipple(FXBitmap* bitmap,FXint dx,FXint dy){ 
  stipple=bitmap; 
  pattern=STIPPLE_NONE; 
  tx=dx; 
  ty=dy;
  }


// Set stipple pattern
void FXDC::setStipple(FXStipplePattern pat,FXint dx,FXint dy){ 
  pattern=pat; 
  stipple=NULL; 
  tx=dx; 
  ty=dy; 
  }


// Set clip rectangle
void FXDC::setClipRectangle(FXint,FXint,FXint,FXint){ }
 

// Clear clipping
void FXDC::clearClipRectangle(){ }


// Set clip mask
void FXDC::setClipMask(FXBitmap* bitmap,FXint dx,FXint dy){ 
  mask=bitmap; 
  cx=dx; 
  cy=dy; 
  }


// Clear clip mask
void FXDC::clearClipMask(){ 
  mask=NULL;
  cx=0;
  cy=0;
  }


// Set font to draw text with
void FXDC::setTextFont(FXFont *fnt){ 
  font=fnt; 
  }


// Change clip-against-child windows mode
void FXDC::clipChildren(FXbool){ }


// Clean up
FXDC::~FXDC(){ }
  

