/********************************************************************************
*                                                                               *
*                         J P E G   I c o n   O b j e c t                       *
*                                                                               *
*********************************************************************************
* Author: David Tyree   Email: celer@ipro.lug.usf.edu                           *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXJPEGIcon.cpp,v 1.4 1999/11/18 07:39:38 jeroen Exp $                    *
********************************************************************************/
#include "fxdefs.h"
#include "FXStream.h"
#include "FXString.h"
#include "FXObject.h"
#include "FXDict.h"
#include "FXRegistry.h"
#include "FXApp.h"
#include "FXId.h"
#include "FXDrawable.h"
#include "FXImage.h"
#include "FXIcon.h"
#include "FXJPEGIcon.h"


/*
  Notes:
*/


/*******************************************************************************/

FXIMPLEMENT(FXJPEGIcon,FXIcon,NULL,0)


// Initialize
FXJPEGIcon::FXJPEGIcon(FXApp* a,const void *pix,FXuint opts,FXint w,FXint h):
  FXIcon(a,NULL,opts,w,h){
  quality=75;
  if(pix){     
    FXMemoryStream ms;
    ms.open((FXuchar *)pix,FXStreamLoad);
    loadPixels(ms);
    ms.close();   
    }
  }    


// Save pixels only
void FXJPEGIcon::savePixels(FXStream& store) const {
  FXASSERT(!(options&IMAGE_ALPHA));
  fxsaveJPEG(store,data,transp,width,height,quality);   
  }


// Load pixels only
void FXJPEGIcon::loadPixels(FXStream& store){
  FXColor clearcolor=0;
  if(options&IMAGE_OWNED){FXFREE(&data);}
  fxloadJPEG(store,data,transp,width,height,quality);   
  if(!(options&IMAGE_ALPHACOLOR)) transp=clearcolor;
  if(options&IMAGE_ALPHAGUESS) transp=guesstransp();
  if(transp==0) options|=IMAGE_OPAQUE;
  options&=~IMAGE_ALPHA;
  options|=IMAGE_OWNED;
  }    


// Clean up
FXJPEGIcon::~FXJPEGIcon(){
  }
