/* Copyright (C) 1991, 1992, 1993 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <ansidecl.h>
#include <errno.h>
#include <limits.h>
#include <stddef.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>

char *__ttyname = NULL;

static char * getttyname __P ((int fd, dev_t mydev, ino_t myino,
			       int save, int *dostat));

static char *
getttyname (fd, mydev, myino, save, dostat)
  int fd;
  dev_t mydev;
  ino_t myino;
  int save;
  int *dostat;
{
  static CONST char dev[] = "/dev";
  static char *name = NULL;
  static size_t namelen = 0;
  struct stat st;
  DIR *dirstream;
  struct dirent *d;
  int d_namlen;

  dirstream = opendir (dev);
  if (dirstream == NULL)
  {
    *dostat = -1;
    return NULL;
  }

  while ((d = readdir (dirstream)) != NULL)
    if ((d->d_ino == myino || *dostat)
	&& strcmp (d->d_name, "stdin")
	&& strcmp (d->d_name, "stdout")
	&& strcmp (d->d_name, "stderr"))
      {
	d_namlen = strlen (d->d_name) + 1;
	if (sizeof (dev) + d_namlen > namelen)
	  {
	    if (name)
	      free (name);
	    namelen = (sizeof (dev) + d_namlen) << 1; /* Big enough.  */
	    name = malloc (namelen);
	    if (! name)
	    {
	      *dostat = -1;
	      (void) closedir (dirstream);
	      return NULL;
	    }
	    (void) memcpy (name, dev, sizeof (dev) - 1);
	    name[sizeof (dev) - 1] = '/';
	  }
	(void) memcpy (&name[sizeof (dev)], d->d_name,
		d_namlen);
	if (stat (name, &st) == 0 && S_ISCHR (st.st_mode)
	    && st.st_rdev == mydev)
	  {
	    (void) closedir (dirstream);
	    __ttyname = name;
	    errno = save;
	    return name;
	  }
      }

  (void) closedir (dirstream);
  errno = save;
  return NULL;
}

/* Return the pathname of the terminal FD is open on, or NULL on errors.
   The returned storage is good only until the next call to this function.  */
char *
DEFUN(ttyname, (fd), int fd)
{
  struct stat st;
  int dostat = 0;
  int save = errno;
  char *name;

  if (isatty (fd) && fstat (fd, &st) < 0)
    return NULL;

  name = getttyname (fd, st.st_rdev, st.st_ino, save, &dostat);

  if (!name && dostat != -1)
    {
      dostat = 1;
      name = getttyname (fd, st.st_rdev, st.st_ino, save, &dostat);
    }

  return name;
}
