/*
 * rds.c - written in 1998 by Andreas Beck   becka@ggi-project.org
 *
 * This is a demonstration of LibGGI's functions and can be used as a
 * reference programming example.
 *
 *   This software is placed in the public domain and can be used freely
 *   for any purpose. It comes without any kind of warranty, either
 *   expressed or implied, including, but not limited to the implied
 *   warranties of merchantability or fitness for a particular purpose.
 *   Use it at your own risk. the author is not responsible for any damage
 *   or consequences raised by use or inability to use this program.
 */

#include <stdlib.h>
#include <ggi/ggi.h>

ggi_visual_t *vis;

int
main(int argc, char *argv[])
{
	int maxz,x,y,xz,last;

	ggi_mode mode;
	int xmax, ymax, colorsmax;
	ggi_pixel z;

	if (ggiInit() != 0) {
		fprintf(stderr, "%s: unable to initialize libggi, exiting.\n",
			argv[0]);
		exit(1);
	}
	if ((vis=ggiOpen(NULL)) == NULL) {
		fprintf(stderr,
			"%s: unable to open default visual, exiting.\n",
			argv[0]);
		exit(1);
	}
	ggiSetFlags(vis, GGIFLAG_ASYNC);

	if (ggiSetGraphMode(vis,GGI_AUTO,GGI_AUTO,GGI_AUTO,GGI_AUTO,GT_AUTO))
		ggiPanic("Cannot set default mode!\n");

	ggiGetMode(vis, &mode);
	xmax = mode.virt.x;
	ymax = mode.virt.y;

	colorsmax = 1 << GT_DEPTH(mode.graphtype);

	if (mode.graphtype == GT_8BIT) {
		int i;
		ggi_color colormap[256];		

		for (i=0; i<256; i++) {
			colormap[i].r=((i&0xe0)>>5)*0x2492;
			colormap[i].g=((i&0x1c)>>2)*0x2492;
			colormap[i].b=((i&0x03)   )*0x5555;
		}

		ggiSetPalette(vis, 0, 256, colormap);
	}

#if 0
	for (y=0; y<ymax; y++) {
		for (x=0; x<xmax; x++) {
			ggiPutPixel(vis,x,y,((x+y)/25)&15);
		}
	}
#endif

#if 1
	ggiSetGCForeground(vis,15);
	ggiDrawBox(vis, 6*xmax/21,  ymax/4        ,5*xmax/21,ymax/20);
	ggiDrawBox(vis, 6*xmax/21,  ymax/4        ,  xmax/21,ymax/ 2);
	ggiDrawBox(vis, 6*xmax/21,3*ymax/4-ymax/20,5*xmax/21,ymax/20);
	ggiDrawBox(vis, 8*xmax/21,  ymax/2        ,3*xmax/21,ymax/20);
	ggiDrawBox(vis,10*xmax/21,  ymax/2        ,  xmax/21,ymax/ 4);

	ggiSetGCForeground(vis,5);
	ggiDrawBox(vis,12*xmax/21,  ymax/4        ,5*xmax/21,ymax/20);
	ggiDrawBox(vis,12*xmax/21,  ymax/4        ,  xmax/21,ymax/ 2);
	ggiDrawBox(vis,12*xmax/21,3*ymax/4-ymax/20,5*xmax/21,ymax/20);
	ggiDrawBox(vis,14*xmax/21,  ymax/2        ,3*xmax/21,ymax/20);
	ggiDrawBox(vis,16*xmax/21,  ymax/2        ,  xmax/21,ymax/ 4);

	ggiSetGCForeground(vis,10);
	ggiDrawBox(vis,6*xmax/7        ,  ymax/4        ,xmax/7 ,ymax/20);
	ggiDrawBox(vis,6*xmax/7+xmax/21,  ymax/4        ,xmax/21,ymax/ 2);
	ggiDrawBox(vis,6*xmax/7        ,3*ymax/4-ymax/20,xmax/7 ,ymax/20);
#endif


	ggiSetGCForeground(vis,15);
	ggiSetGCBackground(vis, 0);

#if 0
	if (mode.graphtype==GT_TEXT16 || mode.graphtype==GT_TEXT32) {
		ggiPuts(vis,10, 7,"\x20\x20\xdb\xdb\xdb\xdb\x20\x20\x20\x20\xdb\xdb\xdb\xdb\x20\x20\x20\xdb\xdb\xdb");
		ggiPuts(vis,10, 8,"\x20\xdb\x20\x20\x20\x20\xdb\x20\x20\xdb\x20\x20\x20\x20\xdb\x20\x20\x20\xdb\x20");
		ggiPuts(vis,10, 9,"\x20\xdb\x20\x20\x20\x20\xdb\x20\x20\xdb\x20\x20\x20\x20\xdb\x20\x20\x20\xdb\x20");
		ggiPuts(vis,10,10,"\x20\xdb\x20\x20\x20\x20\x20\x20\x20\xdb\x20\x20\x20\x20\x20\x20\x20\x20\xdb\x20");
		ggiPuts(vis,10,11,"\x20\xdb\x20\x20\x20\xdb\xdb\x20\x20\xdb\x20\x20\x20\xdb\xdb\x20\x20\x20\xdb\x20");
		ggiPuts(vis,10,12,"\x20\xdb\x20\x20\x20\x20\xdb\x20\x20\xdb\x20\x20\x20\x20\xdb\x20\x20\x20\xdb\x20");
		ggiPuts(vis,10,13,"\x20\xdb\x20\x20\x20\x20\xdb\x20\x20\xdb\x20\x20\x20\x20\xdb\x20\x20\x20\xdb\x20");
		ggiPuts(vis,10,14,"\x20\x20\xdb\xdb\xdb\xdb\x20\x20\x20\x20\xdb\xdb\xdb\xdb\x20\x20\x20\xdb\xdb\xdb");
	} else {
		ggiPuts(vis,xmax/2-80,ymax/2-48,"\x20\x20\xdb\xdb\xdb\xdb\x20\x20\x20\x20\xdb\xdb\xdb\xdb\x20\x20\x20\xdb\xdb\xdb");
		ggiPuts(vis,xmax/2-80,ymax/2-40,"\x20\xdb\x20\x20\x20\x20\xdb\x20\x20\xdb\x20\x20\x20\x20\xdb\x20\x20\x20\xdb\x20");
		ggiPuts(vis,xmax/2-80,ymax/2-32,"\x20\xdb\x20\x20\x20\x20\xdb\x20\x20\xdb\x20\x20\x20\x20\xdb\x20\x20\x20\xdb\x20");
		ggiPuts(vis,xmax/2-80,ymax/2-24,"\x20\xdb\x20\x20\x20\x20\x20\x20\x20\xdb\x20\x20\x20\x20\x20\x20\x20\x20\xdb\x20");
		ggiPuts(vis,xmax/2-80,ymax/2-16,"\x20\xdb\x20\x20\x20\xdb\xdb\x20\x20\xdb\x20\x20\x20\xdb\xdb\x20\x20\x20\xdb\x20");
		ggiPuts(vis,xmax/2-80,ymax/2- 8,"\x20\xdb\x20\x20\x20\x20\xdb\x20\x20\xdb\x20\x20\x20\x20\xdb\x20\x20\x20\xdb\x20");
		ggiPuts(vis,xmax/2-80,ymax/2   ,"\x20\xdb\x20\x20\x20\x20\xdb\x20\x20\xdb\x20\x20\x20\x20\xdb\x20\x20\x20\xdb\x20");
		ggiPuts(vis,xmax/2-80,ymax/2+ 8,"\x20\x20\xdb\xdb\xdb\xdb\x20\x20\x20\x20\xdb\xdb\xdb\xdb\x20\x20\x20\xdb\xdb\xdb");
	}
#endif

	for (y=0; y<ymax; y++) {
		for (x=0; x<xmax/5; x++)
			ggiPutPixel(vis,x,y,random()%colorsmax/*(x+y)&15*/);
	}

	for (y=0; y<ymax; y++) {
		maxz = -1;
		last = 0;
		for (x=xmax/5; x<xmax; x++) {
				ggiGetPixel(vis, x, y, &z);
				xz = (x-xmax/5)+z;
				if (xz<=maxz) {
					xz=random()%(xmax/5)/*last*/;
				} else {
					maxz=xz;
				}
				
				ggiGetPixel(vis,last=xz,y,&z);
				ggiPutPixel(vis,x,y,z);
			}
	}
	ggiFlush(vis);
	ggiGetc(vis);
	ggiClose(vis);
	ggiExit();
	return 0;
}
