/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998, 1999  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL_romaudio.c,v 1.2 1999/12/09 22:31:53 hercules Exp $";
#endif

/* Allow access to a raw mixing buffer */

#include <stdlib.h>
#include <stdio.h>

#include "SDL_endian.h"
#include "SDL_audio.h"
#include "SDL_audiomem.h"
#include "SDL_romaudio.h"

/* Audio driver functions */
#if 0
static int Mac_OpenAudio(_THIS, SDL_AudioSpec *spec);
static void Mac_WaitAudio(_THIS);
static void Mac_PlayAudio(_THIS);
static Uint8 *Mac_GetAudioBuf(_THIS);
static void Mac_CloseAudio(_THIS);
#endif

/* Audio driver bootstrap functions */

static int Audio_Available(void)
{
	return(0);	/* Not yet implemented */
}

static void Audio_DeleteDevice(SDL_AudioDevice *device)
{
	free(device->hidden);
	free(device);
}

static SDL_AudioDevice *Audio_CreateDevice(int devindex)
{
	SDL_AudioDevice *this;

	/* Initialize all variables that we clean on shutdown */
	this = (SDL_AudioDevice *)malloc(sizeof(SDL_AudioDevice));
	if ( this ) {
		memset(this, 0, (sizeof *this));
		this->hidden = (struct SDL_PrivateAudioData *)
				malloc((sizeof *this->hidden));
	}
	if ( (this == NULL) || (this->hidden == NULL) ) {
		SDL_OutOfMemory();
		if ( this ) {
			free(this);
		}
		return(0);
	}
	memset(this->hidden, 0, (sizeof *this->hidden));

	/* Set the function pointers */
#if 0
	this->OpenAudio = Mac_OpenAudio;
	this->WaitAudio = Mac_WaitAudio;
	this->PlayAudio = Mac_PlayAudio;
	this->GetAudioBuf = Mac_GetAudioBuf;
	this->CloseAudio = Mac_CloseAudio;
#endif

	this->free = Audio_DeleteDevice;

	return this;
}

AudioBootStrap AUDIO_bootstrap = {
	"toolbox", Audio_Available, Audio_CreateDevice
};

