/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    5635-34 Springhouse Dr.
    Pleasanton, CA 94588 (USA)
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL.c,v 1.14 1999/07/21 06:08:24 slouken Exp $";
#endif

/* Initialization code for SDL */

#include "SDL.h"
#include "SDL_endian.h"
#include "SDL_fatal.h"
#include "SDL_leaks.h"

/* Initialization/Cleanup routines */
extern void SDL_StartTicks(void);
extern int  SDL_TimerInit(void);
extern int  SDL_VideoInit(Uint32 flags);
extern int  SDL_CDROMInit(void);
extern void SDL_TimerQuit(void);
extern void SDL_VideoQuit(void);
extern void SDL_CDROMQuit(void);

/* The current SDL version */
static SDL_version version = 
	{ SDL_MAJOR_VERSION, SDL_MINOR_VERSION, SDL_PATCHLEVEL };

/* The initialized subsystems */
Uint32 initialized = 0;

/* Useful if the library needs to lock itself into memory for some reason */
int _SDL_lockSO = 0;

#ifdef CHECK_LEAKS
int surfaces_allocated = 0;
#endif

int SDL_Init(Uint32 flags)
{
	/* Initialize the timer subsystem */
	SDL_StartTicks();
	if ( (flags & SDL_INIT_TIMER) && !(initialized & SDL_INIT_TIMER) ) {
		if ( SDL_TimerInit() < 0 ) {
			return(-1);
		}
		initialized |= SDL_INIT_TIMER;
	}

	/* Initialize the video/event subsystem */
	if ( (flags & SDL_INIT_VIDEO) && !(initialized & SDL_INIT_VIDEO) ) {
		if ( SDL_VideoInit(flags&SDL_INIT_EVENTTHREAD) < 0 ) {
			return(-1);
		}
		initialized |= SDL_INIT_VIDEO;
	}

	/* Initialize the CD-ROM subsystem */
	if ( (flags & SDL_INIT_CDROM) && !(initialized & SDL_INIT_CDROM) ) {
		if ( SDL_CDROMInit() < 0 ) {
			return(-1);
		}
		initialized |= SDL_INIT_CDROM;
	}

#if defined(__BEOS__) || defined(WIN32)
	/* Wierd, on BeOS and Win32, freeing the dynamic library causes
	   a crash on exit.  Something is pointing into the SDL shared
	   library image after we quit.
	*/
	_SDL_lockSO = 1;
#endif

	/* Everything is initialized */
	SDL_InstallParachute();
	return(0);
}

void SDL_Quit(void)
{
	/* Shut down all initialized subsystems */
	if ( initialized & SDL_INIT_CDROM ) {
		SDL_CDROMQuit();
		initialized &= ~SDL_INIT_CDROM;
	}
	if ( initialized & SDL_INIT_VIDEO ) {
		SDL_VideoQuit();
		initialized &= ~SDL_INIT_VIDEO;
	}
	if ( initialized & SDL_INIT_TIMER ) {
		SDL_TimerQuit();
		initialized &= ~SDL_INIT_TIMER;
	}
	SDL_ClearError();

#ifdef CHECK_LEAKS
	if ( surfaces_allocated != 0 ) {
		fprintf(stderr, "SDL Warning: %d SDL surfaces extant\n", 
							surfaces_allocated);
	}
#endif
}

/* Stub, only meaningful in the dynamic library */
void SDL_SetLibraryPath(const char *path)
{
	return;
}

/* Exported for the dynamic loader */
int SDL_LockSO(void)
{
	return(_SDL_lockSO);
}

/* Return the library version number */
const SDL_version * SDL_Linked_Version(void)
{
	return(&version);
}

