/*
 * dump-fig.c --
 *
 *      Operations to dump graphic representation of MIBs in fig format.
 *
 * Copyright (c) 1999 J. Schoenwaelder, Technical University of Braunschweig.
 *
 * See the file "COPYING" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 *
 * @(#) $Id: dump-fig.c,v 1.1 1999/10/05 15:52:21 strauss Exp $
 */

#include <stdlib.h>
#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>
#include <string.h>
#include <strings.h>
#include <errno.h>
#include <stdarg.h>

#include "smi.h"
#include "smidump.h"


#define	 X_OFFSET	225
#define	 Y_OFFSET	225
#define	 X_INDENT	225
#define	 Y_INDENT	225



static void printString(int x, int y, int angle, char *string)
{
    int height = 180, length = 22;

    printf("4 0 0 0 0 18 12 0.0 4 %d %d %d %d %s\\001\n",
	   height, length, x, y, string);
}



static int isGroup(SmiNode *smiNode)
{
    SmiNode *childNode;
    
    for(childNode = smiGetFirstChildNode(smiNode);
	childNode;
	childNode = smiGetNextChildNode(childNode)) {
	if ((childNode->nodekind == SMI_NODEKIND_SCALAR
	     || childNode->nodekind == SMI_NODEKIND_TABLE)
	    && childNode->status == SMI_STATUS_CURRENT) {
	    return 1;
	}
    }

    return 0;
}


static void printGroup(int *x, int *y, SmiNode *smiNode)
{
    SmiNode *childNode;
    char string[4096];

    *y += Y_OFFSET;
    printString(*x, *y, 0, smiNode->name);

    for(childNode = smiGetFirstChildNode(smiNode);
	childNode;
	childNode = smiGetNextChildNode(childNode)) {
	if (childNode->nodekind == SMI_NODEKIND_SCALAR
	    || childNode->nodekind == SMI_NODEKIND_COLUMN) {
	    if (childNode->status != SMI_STATUS_OBSOLETE) {
		*y += Y_OFFSET;
		sprintf(string, "%s(%d)", childNode->name,
			childNode->oid[childNode->oidlen-1]);
		printString(*x + X_INDENT, *y, 0, string);
	    }
	}
    }
    *y += Y_OFFSET;
}



static void printGroups(int *x, int *y, char *modulename)
{
    SmiNode *smiNode;

    for(smiNode = smiGetFirstNode(modulename, SMI_NODEKIND_ANY);
	smiNode;
	smiNode = smiGetNextNode(smiNode, SMI_NODEKIND_ANY)) {
	if (isGroup(smiNode)) {
	    printGroup(x, y, smiNode);
	}
	if (smiNode->nodekind == SMI_NODEKIND_ROW) {
	    printGroup(x, y, smiNode);
	}
    }
}



int dumpFig(char *modulename)
{
    SmiModule    *smiModule;
    int		 x, y;

    smiModule = smiGetModule(modulename);
    if (!smiModule) {
	fprintf(stderr, "smidump: cannot locate module `%s'\n", modulename);
	exit(1);
    }

    printf("#FIG 3.2\n"
	   "#\n"
	   "# This FIG file has been generated by smidump " VERSION
	   ". Do not edit.\n#\n");

    printf("Landscape\n"
	   "Center\n"
	   "Metric\n"
	   "A4\n"
	   "50.00\n"
	   "Single\n"
	   "-1\n"
	   "1200 2\n");

    x = X_OFFSET, y = Y_OFFSET;
    printGroups(&x, &y, modulename);

    return 0;
}
