/* Perfect hash generated by command line:
 * ./a.out 2
 */
#define MIN_HASH_VALUE	2
#define MAX_HASH_VALUE	87
#define MIN_KEYWORD_LEN 2
#define MAX_KEYWORD_LEN 11

static unsigned char Keyword_Hash_Table [256] =
{
   88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,
   88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,
   88,   3,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,
    3,  15,   6,  18,  21,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,
   88,  88,   0,   0,  88,   0,  88,  88,  88,   9,  88,   0,   0,  88,  88,   0,
   88,  88,   0,   0,   0,   0,  88,  88,   0,  88,  88,  88,  88,  88,  88,   0,
   88,   3,  12,  27,   6,   0,  21,  18,  36,   0,  88,   0,  36,  12,   0,   0,
   27,   0,   0,  12,   0,   0,   0,   0,   6,   0,  88,  88,  88,  88,  88,  88,
   88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,
   88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,
   88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,
   88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,
   88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,
   88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,
   88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,
   88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88,  88
};

static unsigned char keyword_hash (char *s, unsigned int len)
{
   unsigned int sum;

   sum = len;
   while (len)
     {
	len--;
	sum += (unsigned int) Keyword_Hash_Table [(unsigned char)s[len]];
     }
   return sum;
}

typedef struct
{
   char *name;
   unsigned int type;
}
Keyword_Table_Type;

Keyword_Table_Type Keyword_Table [/* 86 */] =
{
   {"or",	OR_TOKEN},
   {"not",	NOT_TOKEN},
   {NULL,0},
   {NULL,0},
   {"return",	RETURN_TOKEN},
   {NULL,0},
   {"do",	DO_TOKEN},
   {"xor",	BXOR_TOKEN},
   {NULL,0},
   {"ERROR_BLOCK",	ERRBLK_TOKEN},
   {"and",	AND_TOKEN},
   {NULL,0},
   {"USER_BLOCK0",	USRBLK0_TOKEN},
   {"sqr",	SQR_TOKEN},
   {NULL,0},
   {"USER_BLOCK2",	USRBLK1_TOKEN},
   {NULL,0},
   {"EXIT_BLOCK",	EXITBLK_TOKEN},
   {"break",	BREAK_TOKEN},
   {"mod",	MOD_TOKEN},
   {NULL,0},
   {"if",	IF_TOKEN},
   {"for",	FOR_TOKEN},
   {"_for",	_FOR_TOKEN},
   {"USER_BLOCK1",	USRBLK1_TOKEN},
   {"!if",	IFNOT_TOKEN},
   {"forever",	FOREVER_TOKEN},
   {"USER_BLOCK3",	USRBLK1_TOKEN},
   {"abs",	ABS_TOKEN},
   {NULL,0},
   {"USER_BLOCK4",	USRBLK1_TOKEN},
   {"define",	DEFINE_TOKEN},
   {"sign",	SIGN_TOKEN},
   {"continue",	CONT_TOKEN},
   {NULL,0},
   {NULL,0},
   {NULL,0},
   {NULL,0},
   {NULL,0},
   {NULL,0},
   {NULL,0},
   {NULL,0},
   {NULL,0},
   {"struct",	STRUCT_TOKEN},
   {"case",	CASE_TOKEN},
   {NULL,0},
   {"static",	STATIC_TOKEN},
   {NULL,0},
   {NULL,0},
   {"shr",	SHR_TOKEN},
   {"else",	ELSE_TOKEN},
   {NULL,0},
   {"orelse",	ORELSE_TOKEN},
   {NULL,0},
   {NULL,0},
   {"pop",	POP_TOKEN},
   {"mul2",	MUL2_TOKEN},
   {NULL,0},
   {NULL,0},
   {"typedef",	TYPEDEF_TOKEN},
   {"variable",	VARIABLE_TOKEN},
   {NULL,0},
   {"andelse",	ANDELSE_TOKEN},
   {NULL,0},
   {NULL,0},
   {"loop",	LOOP_TOKEN},
   {NULL,0},
   {NULL,0},
   {NULL,0},
   {NULL,0},
   {NULL,0},
   {"exch",	EXCH_TOKEN},
   {NULL,0},
   {NULL,0},
   {NULL,0},
   {"while",	WHILE_TOKEN},
   {"chs",	CHS_TOKEN},
   {NULL,0},
   {NULL,0},
   {"switch",	SWITCH_TOKEN},
   {NULL,0},
   {NULL,0},
   {NULL,0},
   {NULL,0},
   {"do_while",	DOWHILE_TOKEN},
   {"shl",	SHL_TOKEN},
};

static Keyword_Table_Type *is_keyword (char *str, unsigned int len)
{
   unsigned int hash;
   char *name;
   Keyword_Table_Type *kw;

   if ((len < MIN_KEYWORD_LEN)
       || (len > MAX_KEYWORD_LEN))
     return NULL;

   hash = keyword_hash (str, len);
   if ((hash > MAX_HASH_VALUE) || (hash < MIN_HASH_VALUE))
     return NULL;

   kw = &Keyword_Table[hash - MIN_HASH_VALUE];
   if ((NULL != (name = kw->name))
       && (*str == *name)
       && (0 == strcmp (str, name)))
     return kw;
   return NULL;
}
