/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef FILETREEDIALOG_H
#define FILETREEDIALOG_H

#include <vdk/vdk.h>
#include <vdk/dirtree.h>
/*
 * Dirtree widget is a part of GTK See distribution, which
 * is under GPL version 2.
 * Original author: Hotaru Lee <hotaru@163.net>
 */
typedef VDKArray<VDKString> FileStringArray;
///////////////////////////////////////
// 
///////////////////////////////////////
class VDKFileTreeDialog: public VDKForm
{
  void LoadDir(char* dir);
  char** GetFileIcon(char* name);
protected:
  static void SelectionChanged(GtkWidget*, gpointer);
  GtkWidget *tree;
  VDKScrolled *treewin;  
  GtkAdjustment *vadj;
  VDKString home;
  VDKString first_pcwd,pcwd;
  FileStringArray* selections;
  VDKLabelButton *open,*cancel;
  VDKEntry *dir_label;
  VDKCheckButton *hiddenCb;
  VDKCustomSortedList *filelist;
  bool init();
  void OnShow(VDKForm*);
  bool OpenClick(VDKObject*);
  bool CancelClick(VDKObject*);
  bool ToggleHidden(VDKObject*);
public:
  VDKFileTreeDialog(VDKForm* owner,
		FileStringArray* selections,
		char* title = "", 
		GtkWindowType display = GTK_WINDOW_TOPLEVEL);
   
  ~VDKFileTreeDialog(){};
  virtual void Setup(void) {}
  void Adjust(char* dir);
  DECLARE_SIGNAL_MAP(VDKFileTreeDialog);
};
#endif
