/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */


#ifndef FRAME_H
#define FRAME_H
#include <vdk/vdkobj.h>
#include <vdk/boxes.h>
#include <vdk/vdkprops.h>
#include <vdk/widcontain.h>
class VDKFrame: public VDKObjectContainer
{
 protected:
  VDKBox* box;
  void SetLabel(char* label)
    { gtk_frame_set_label(GTK_FRAME(widget),label); }
  void SetShadow(int shadow)
    { gtk_frame_set_shadow_type(GTK_FRAME(widget),(GtkShadowType) shadow); }
  void SetAlign(int j);
public:
  // properties
  __rwproperty(VDKFrame, char*) Label;
  __rwproperty(VDKFrame, int) Shadow;
  __rwproperty(VDKFrame, int) Align;
  //
  VDKFrame(VDKForm* owner,
	   char* label = (char*) NULL,
	   int mode = v_box,
	   int shadow = shadow_in);
  ~VDKFrame() {}
  void Add(VDKObject* obj,int justify = l_justify,
	   int expand = TRUE, int fill = TRUE , int padding = 0);
};

#endif
