/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.5
 * December 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 

#ifndef VDKCTREE_H
#define VDKCTREE_H
#include <vdk/vdkcustom.h>
/*
 */
typedef GtkCTreeNode*                  VDKTreeNode;
typedef VDKArray<VDKTreeNode>          VDKTreeNodeArray;
typedef VDKList<GtkCTreeNode>          VDKTreeNodeList;
typedef VDKListIterator<GtkCTreeNode>  VDKTreeNodeListIterator;
/*
 */
class VDKCustomTree: public VDKCustom
{
  int tree_column;
 protected:
  VDKTreeNodeArray WideSelection;

  static void ColumnClick(GtkWidget* w,
		  gint column,
		  gpointer s);
  static void NodeSelection(GtkWidget* ,
		  GtkCTreeNode* node,
		  int column,
		  gpointer s);
  static void NodeUnselection(GtkWidget* ,
		  GtkCTreeNode* node,
		  int column,
		  gpointer s);
  static int  ButtonPress (GtkWidget* wid, 
			   GdkEventButton *ev, 
			   gpointer s);

  void SetStyle(VDKTreeNode node);
  void ConnectSignals();
  void SetSpacing(int sp)
    { gtk_ctree_set_spacing(GTK_CTREE(custom_widget), sp); }
  void SetLineStyle(GtkCTreeLineStyle ls)
    { gtk_ctree_set_line_style (GTK_CTREE(custom_widget), ls); }
  void SetExpanderStyle(GtkCTreeExpanderStyle es)
    { gtk_ctree_set_expander_style (GTK_CTREE(custom_widget), es); }
  void SetSelectedNode(VDKTreeNode node);
  void SetUnselectedNode(VDKTreeNode node);
  // properties
 public:
  __rwproperty(VDKCustomTree,int) Spacing;
  __rwproperty(VDKCustomTree,VDKTreeNode) SelectedNode;
  __rproperty(VDKCustomTree,int) SelectedColumn;
  __rwproperty(VDKCustomTree,VDKTreeNode) UnselectedNode;
  __rproperty(VDKCustomTree,int) UnselectedColumn;
  __rwproperty(VDKCustomTree,GtkCTreeLineStyle) LineStyle;
  __rwproperty(VDKCustomTree,GtkCTreeExpanderStyle) ExpanderStyle;
 public:
  VDKCustomTree(VDKForm* owner,
		int columns = 1,
		char **titles = NULL,
		GtkSelectionMode mode = GTK_SELECTION_SINGLE,
		int tree_column = 0);
  virtual ~VDKCustomTree();
  VDKTreeNode AddNode(char  *text[],
		      GtkCTreeNode *parent,
		      bool expanded = true,
		      bool isLeaf = false,
		      char **pixmap_closed = NULL,
		      char** pixmap_opened = NULL );
  bool RemoveNode(VDKTreeNode node);
  int RemoveKey(char* key);
  virtual void Clear();
  // selection (most for similarity with VDKCustomList)
  VDKTreeNode Selection() { return SelectedNode; }
  VDKTreeNode Unselection() { return UnselectedNode; }
  VDKTreeNodeArray& Selections();
  // access operator
  Tuple operator[](VDKTreeNode node);
  VDKTreeNodeList* Find(char* key);
  // some useful functions on nodes
  bool IsLeaf(VDKTreeNode node);
  char* Key(VDKTreeNode node);
  bool IsExpanded(VDKTreeNode node);
#ifdef USE_SIGCPLUSPLUS
 public:
  VDKSignal2<void, VDKTreeNode, int> OnNodeSelect;
  VDKSignal2<void, VDKTreeNode, int> OnNodeUnselect;
  VDKSignal3<void, VDKTreeNode, VDKTreeNode, VDKTreeNode> OnTreeMove;
  VDKSignal1<void, VDKTreeNode> OnTreeExpand;
 protected:  
  static void make_gtksigc_connection(VDKCustomTree* obj);
 private:
  static void _handle_tree_move(GtkWidget*, GtkCTreeNode* node, 
				GtkCTreeNode* new_parent,
				GtkCTreeNode* new_sibling, 
				gpointer obj);
  static void _handle_tree_expand(GtkWidget*, GtkCTreeNode* node,
				  gpointer obj);
#endif /* USE_SIGCPLUSPLUS */
};

#endif
