/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.6.2
 * May 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _vdkcustombutton_h
#define _vdkcustombutton_h
#include <vdk/vdkobj.h>
#include <vdk/boxes.h>
#include <vdk/label.h>
#include <vdk/pixmaps.h>
#include <vdk/menu.h>
#include <vdk/gtkcombobutton.h>

class VDKCustomButton: public VDKObject
{
 protected:
  void ConnectButtonSignals();
  static void ToggleEvent(GtkWidget *wid, gpointer gp);
 public:
// properties
  VDKReadOnlyValueProp<VDKCustomButton,  VDKBox*> ButtonBox;
  VDKReadOnlyValueProp<VDKCustomButton,  VDKLabel*> Label;
  VDKReadOnlyValueProp<VDKCustomButton,  VDKPixmap*> Pixmap;
  VDKReadWriteValueProp<VDKCustomButton, char*> Caption;
  VDKReadWriteValueProp<VDKCustomButton, bool> CaptionWrap;
  VDKReadWriteValueProp<VDKCustomButton, bool> Checked;
  VDKReadWriteValueProp<VDKCustomButton, GtkReliefStyle> Relief;

  VDKCustomButton(VDKForm* owner, 
		  char* label,
		  unsigned int type = 
		  VDK_CBUTTON_UNTOGGLED |  VDK_CBUTTON_NORMAL);

  VDKCustomButton(VDKForm* owner, 
		  char* pixfile, 
		  char* label,
		  unsigned int type = 
		  VDK_CBUTTON_UNTOGGLED |  VDK_CBUTTON_NORMAL,
		  GtkPositionType position = GTK_POS_RIGHT);

  VDKCustomButton(VDKForm* owner, 
		  char** pixdata, 
		  char* label,
		  unsigned int type = 
		  VDK_CBUTTON_UNTOGGLED |  VDK_CBUTTON_NORMAL,
		  GtkPositionType position = GTK_POS_RIGHT);

  ~VDKCustomButton();

  void SetComboMenu(VDKMenu* menu);

  /*
   */
  virtual void SetForeground(VDKRgb color, 
			     GtkStateType state = GTK_STATE_NORMAL) 
    {
      VDKLabel *label = Label;
      if( label)
        _setForeground_(label->Widget(),
			color.red,
			color.green,
			color.blue, 
			state);
    }
  /*
   */
  virtual void SetFont(VDKFont* font) 
    {
      VDKLabel *label = Label;
      if( label)
        _setFont_(label->Widget(),font);
    }
  /*
   */
  void SetCaption(char* str) 
    {
      VDKLabel *label = Label;
      if( label)
        label->Caption = str;
    }
  /*
   */
  char* GetCaption () 
    {
      VDKLabel *label = Label;
      if( label)
	return (char*) label->Caption;
      else
	return (char*) NULL;
    }
  /*
   */
  void SetCaptionWrap (bool flag) 
    {
      VDKLabel *label = Label;
      if( label)
	gtk_label_set_line_wrap (GTK_LABEL (label->Widget()), flag);
    }
  /*
   */
  bool GetCaptionWrap () 
    {
      VDKLabel *label = Label;
      if( label)
	return GTK_LABEL (label->Widget())->wrap;
      else
	return false;
    }
  /*
   */
  void SetRelief(GtkReliefStyle style) 
    {
      if(GTK_IS_BUTTON(widget))
	gtk_button_set_relief(GTK_BUTTON(widget), style);
    }
  /*
   */
  GtkReliefStyle GetRelief() 
    {
      if(GTK_IS_BUTTON(widget))
	return gtk_button_get_relief(GTK_BUTTON(widget));
      else
	return GTK_RELIEF_NORMAL;
    }
  /*
   */
  void Toggle() { 
    if(GTK_IS_TOGGLE_BUTTON(widget))
      Checked = Checked ? false : true; 
  }
  /*
   */
  void SetChecked(bool flag)
    {
      if(GTK_IS_TOGGLE_BUTTON(widget))
	gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(widget),flag);
    }
  /*
   */
  bool GetChecked()
    { 
      if(GTK_IS_TOGGLE_BUTTON(widget))
	return GTK_TOGGLE_BUTTON(widget)->active ? true : false; 
      else
	return false;
    }
  /*
   */
  virtual void Enable(bool flag = true);
#ifdef USE_SIGCPLUSPLUS
 public:
  VDKSignal1<void, bool> OnButtonToggled;
  VDKSignal0<void> OnButtonClicked;
  VDKSignal0<void> OnButtonPressed;
  VDKSignal0<void> OnButtonLeave;
 private:
  static void _handle_clicked(GtkWidget*, gpointer);
  static void _handle_pressed(GtkWidget*, gpointer);
  static void _handle_leave(GtkWidget*, gpointer);
#endif /* USE_SIGCPLUSPLUS */
};

#endif
