/*
 * ===========================
 * VDK Visual Development Kit
 * Version 1.0.3
 * November 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 * Based on ISDataBox
 * Developed by Ionutz Borcoman <borco@borco-ei.eng.hokudai.ac.jp>
 * based on  GtkDatabox - An extension to the gtk+ library
 * Copyright (C) 1998-1999 Roland Bock
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef _vdkdnd_h
#define _vdkdnd_h
#include <vdk/vdkobj.h>
#include <vdk/dlist.h>
#include <vdk/vdkprops.h>
#include <vdk/vdkutils.h>
#include <vdk/vdkcustom.h>
#include <vdk/rawpixmap.h>
#define dnd_base_signal user_signal/2
// target side
#define dnd_dropped_signal dnd_base_signal
#define dnd_get_data_signal dnd_base_signal + 1
#define dnd_drag_leave_signal dnd_base_signal + 2
#define dnd_drag_motion_signal dnd_base_signal + 3
 

// forward declaration
class VDKDnD;

/*
*/
class VDKDnDEntry
{
    protected:
        VDKObject* object;
        VDKDnD* dnd;
        GtkWidget* widget;
    public:
        VDKDnDEntry(VDKObject* object, VDKDnD* dnd, GtkWidget* widget);
        VDKObject* Object() { return object; }
        ~VDKDnDEntry() {} 
    friend class VDKDnD;
};


typedef VDKList<VDKDnDEntry> VDKDnDTable; 
typedef VDKListIterator<VDKDnDEntry> VDKDnDIterator; 


/*
*/

class VDKDnD : public VDKRawObject
{
  
    protected:
        
    VDKDnDTable sources, targets;
    GtkTargetEntry *target_table;
    int n_entries;        
    // target side
    static gboolean drag_drop(GtkWidget *widget,
                                    GdkDragContext *context,
                                    gint x,
                                    gint y,
                                    guint time,
                                    gpointer gp);
    static void  drag_leave  (GtkWidget	*widget,
                            GdkDragContext  *context,
                            guint  time,
                            gpointer data);
    static gboolean drag_motion	(GtkWidget	       *widget,
        			    GdkDragContext  *context,
         			    gint x,
         			    gint y,
         			    guint time,
                            gpointer data);

    // source side
    static void source_drag_data_get(GtkWidget *widget,
                                      GdkDragContext     *context,
                            		  GtkSelectionData   *selection_data,
                                      guint               info,
                                      guint               time,
                                      gpointer            data);
    public:
        __rproperty(VDKDnD,VDKObject*) DragSource;
        __rproperty(VDKDnD,VDKPoint) DragPoint;
        VDKDnD(VDKForm* owner,
            GtkTargetEntry* target_table,
            guint n_entries);
        virtual ~VDKDnD();
        void AddTarget(VDKObject* target);
        void AddSource(VDKObject* source);
        void RemoveTarget(VDKObject* target);
        void RemoveSource(VDKObject* source);
	void SetIcon(VDKObject* object, VDKRawPixmap* pixmap);
        VDKDnDTable* DnDSources() { return &sources; }
        VDKDnDTable* DnDTargets() { return &targets; }
};



#endif
