 /*  
file: rbuttonwin.cc
*/
#include "rbuttonwin.h"
/*   
signals map  
*/    
DEFINE_SIGNAL_MAP(RadioButtonWin,VDKForm)
  ON_SIGNAL(group1,toggled_signal,OnToggleRadioGroup),
  ON_SIGNAL(group2,toggled_signal,OnToggleRadioGroup)
END_SIGNAL_MAP 
  
void RadioButtonWin::Setup()
{ 
  VDKRadioButton *button; 
  VDKBox  *box = new VDKBox(this);
  
  VDKBox* vbox = new VDKBox(this,v_box);
  frame = new VDKFrame(this);
   frame->Label = "Radio button group 1";
   group1 = new VDKRadioButtonGroup(this);
   button = new VDKRadioButton(group1,"shadow none");
   button = new VDKRadioButton(group1,"shadow in");
   button = new VDKRadioButton(group1,"shadow out");
   button = new VDKRadioButton(group1,"etched in");
   button = new VDKRadioButton(group1,"etched out");
   group1->SetDefault(1);
   frame->Add(group1); 
   frame->Foreground = clWhite; 
   //frame->Font = new VDKFont(frame,fnLucidaBold12);
  vbox->Add(frame);
  box->Add(vbox); 
  box->Add(new VDKSeparator(this));    
   VDKBox* hbox = new VDKBox(this,h_box); 
   group2 = new VDKRadioButtonGroup(this,h_box);  
   button = new VDKRadioButton(group2,"left align"); 
   button = new VDKRadioButton(group2,"center");
   button = new VDKRadioButton(group2,"right align");
   hbox->Add(group2);
   box->Add(hbox);  
Add(box); 
} 
/*
 */
bool RadioButtonWin::OnToggleRadioGroup(VDKObject* s)
{
VDKRadioButtonGroup* sender = dynamic_cast<VDKRadioButtonGroup*>(s);
if(!sender)
  return true;
if(sender == group1)
  frame->Shadow = sender->Selected;
else
  frame->Align = sender->Selected;
return true;
}

 


