/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include "vdk/pix_togglebutton.h"
#include "vdk/vdkfont.h"
#include "vdk/forms.h"

VDKPixmapToggleButton::VDKPixmapToggleButton (VDKForm* owner,
                                              char* pixfile,
                                              char* label,
                                              char* tip,
                                              GtkPositionType position,
                                              int padding) :
    VDKToggleButton (owner,tip),
    Caption ("Caption", this, label, &VDKPixmapToggleButton::SetCaption, &VDKPixmapToggleButton::GetCaption),
    CaptionWrap ("CaptionWrap", this, true, &VDKPixmapToggleButton::SetCaptionWrap, &VDKPixmapToggleButton::GetCaptionWrap)
{
    GdkBitmap *mask;
    GtkStyle* style = gtk_widget_get_style(owner->Window());
    gdkpixmap = gdk_pixmap_create_from_xpm(owner->Window()->window,
                                        &mask,
                                        &style->bg[GTK_STATE_NORMAL],
                                        pixfile);
    pixmap = gtk_pixmap_new(gdkpixmap,mask);
    gtk_widget_show(pixmap);

    if(label)
      lbl = gtk_label_new (label);
    else
      lbl = NULL;

    switch (position) {
    case (GTK_POS_LEFT) :
        box = gtk_hbox_new (FALSE, padding);
        if(lbl)
	  gtk_box_pack_start (GTK_BOX (box), lbl, FALSE, FALSE, 0);
        gtk_box_pack_start (GTK_BOX (box), pixmap, FALSE, FALSE, 0);
        break;
    case (GTK_POS_RIGHT) :
        box = gtk_hbox_new (FALSE, padding);
        gtk_box_pack_start (GTK_BOX (box), pixmap, FALSE, FALSE, 0);
        if(lbl)
	  gtk_box_pack_start (GTK_BOX (box), lbl, FALSE, FALSE, 0);
        break;
    case (GTK_POS_TOP) :
        box = gtk_vbox_new (FALSE, padding);
        if(lbl)
	  gtk_box_pack_start (GTK_BOX (box), lbl, FALSE, FALSE, 0);
        gtk_box_pack_start (GTK_BOX (box), pixmap, FALSE, FALSE, 0);
        break;
    case (GTK_POS_BOTTOM) :
        box = gtk_vbox_new (FALSE, padding);
        gtk_box_pack_start (GTK_BOX (box), pixmap, FALSE, FALSE, 0);
        if(lbl)
	  gtk_box_pack_start (GTK_BOX (box), lbl, FALSE, FALSE, 0);
        break;
    default:
        break;
    }

    if(lbl)
      gtk_widget_show (lbl);
    gtk_widget_show (box);
    gtk_container_add(GTK_CONTAINER(widget), box);
}

VDKPixmapToggleButton::VDKPixmapToggleButton(VDKForm* owner,
                                 char** pixdata,
                                 char* label,
				 char* tip,
                                 GtkPositionType position,
                                 int padding) :
  VDKToggleButton(owner,tip),
  Caption ("Caption", this, label, &VDKPixmapToggleButton::SetCaption, &VDKPixmapToggleButton::GetCaption),
  CaptionWrap ("CaptionWrap", this, true, &VDKPixmapToggleButton::SetCaptionWrap, &VDKPixmapToggleButton::GetCaptionWrap)

{
    GdkBitmap *mask;
    GtkStyle* style = gtk_widget_get_style(owner->Window());
    gdkpixmap = gdk_pixmap_create_from_xpm_d(owner->Window()->window,
                                        &mask,
                                        &style->bg[GTK_STATE_NORMAL],
                                        pixdata);
    pixmap = gtk_pixmap_new(gdkpixmap,mask);
    gtk_widget_show(pixmap);
    if(label)
      lbl = gtk_label_new (label);
    else
      lbl = NULL;
    switch (position) {
    case (GTK_POS_LEFT) :
        box = gtk_hbox_new (FALSE, padding);
        if(lbl)
	  gtk_box_pack_start (GTK_BOX (box), lbl, FALSE, FALSE, 0);
        gtk_box_pack_start (GTK_BOX (box), pixmap, FALSE, FALSE, 0);
        break;
    case (GTK_POS_RIGHT) :
        box = gtk_hbox_new (FALSE, padding);
        gtk_box_pack_start (GTK_BOX (box), pixmap, FALSE, FALSE, 0);
        if(lbl)
	  gtk_box_pack_start (GTK_BOX (box), lbl, FALSE, FALSE, 0);
        break;
    case (GTK_POS_TOP) :
        box = gtk_vbox_new (FALSE, padding);
        if(lbl)
	  gtk_box_pack_start (GTK_BOX (box), lbl, FALSE, FALSE, 0);
        gtk_box_pack_start (GTK_BOX (box), pixmap, FALSE, FALSE, 0);
        break;
    case (GTK_POS_BOTTOM) :
        box = gtk_vbox_new (FALSE, padding);
        gtk_box_pack_start (GTK_BOX (box), pixmap, FALSE, FALSE, 0);
        if(lbl)
	  gtk_box_pack_start (GTK_BOX (box), lbl, FALSE, FALSE, 0);
        break;
    default:
        break;
    }

    if(lbl)
      gtk_widget_show (lbl);
    gtk_widget_show (box);
    gtk_container_add(GTK_CONTAINER(widget), box);
    //    ConnectDefaultSignals();
}

VDKPixmapToggleButton::~VDKPixmapToggleButton()
{
    if(gdkpixmap)
        gdk_pixmap_unref(gdkpixmap);
} 

void
VDKPixmapToggleButton::SetForeground(VDKRgb color, GtkStateType state)
{
if(lbl)
    _setForeground_(lbl,color.red,color.green,color.blue, state);
}

void
VDKPixmapToggleButton::SetFont(VDKFont* font)
{
if(lbl)
    _setFont_(lbl,font);
}

void VDKPixmapToggleButton::Enable (bool flag) {
    gtk_widget_set_sensitive (pixmap, flag);
    VDKObject::Enable(flag);
}

void VDKPixmapToggleButton::SetCaption(char* str)
{
  if(lbl)
    gtk_label_set_text (GTK_LABEL(lbl),str);
}

char* VDKPixmapToggleButton::GetCaption () {
  if(lbl)
    return GTK_LABEL (lbl)->label;
else
  return NULL;
}

void VDKPixmapToggleButton::SetCaptionWrap (bool flag) {
if(lbl)
    gtk_label_set_line_wrap (GTK_LABEL (lbl), flag);
}

bool VDKPixmapToggleButton::GetCaptionWrap () {
if(lbl)
  return GTK_LABEL (lbl)->wrap;
else
  return false;
}
