/*								-*- C++ -*-
 * $Id: APP_app.cpp,v 1.5 1997-01-30 09:55:40+01 mho Exp $
 *
 * Purpose: wxWindows application and main loop
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "APP_app.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxApp
#define  Uses_wxGDI
#define  Uses_wxPrintSetup
#define  Uses_wxResources
#define  Uses_wxTypeTree
#define  Uses_wxWindow
#define  Uses_wxThread
#include "wx.h"
#define  Uses_ShellWidget  // for XtN... and XtC...
#include <widgets.h>

//-----------------------------------------------------------------------------
// application resources
//-----------------------------------------------------------------------------

typedef struct {
    Boolean debugEvents;
    Boolean debugOutput;
    Boolean debugMemory;
    String  geometry;
    Boolean iconic;
} TwxAPP_DATA;
TwxAPP_DATA wxAPP_DATA;

//- application resources and options -
static XtResource wxAppResources[] = {
    { "debugEvents", "DebugEvents", XtRBoolean, sizeof(Boolean),
      XtOffsetOf(TwxAPP_DATA, debugEvents), XtRImmediate, (XtPointer)FALSE },
    { "debugOutput", "DebugOutput", XtRBoolean, sizeof(Boolean),
      XtOffsetOf(TwxAPP_DATA, debugOutput), XtRImmediate, (XtPointer)FALSE },
    { "debugMemory", "DebugMemory", XtRBoolean, sizeof(Boolean),
      XtOffsetOf(TwxAPP_DATA, debugMemory), XtRImmediate, (XtPointer)FALSE },
    { XtNgeometry, XtCGeometry, XtRString, sizeof(String),
      XtOffsetOf(TwxAPP_DATA, geometry), XtRString, (XtPointer)NULL},
    { XtNiconic, XtCIconic, XtRBoolean, sizeof(Boolean),
      XtOffsetOf(TwxAPP_DATA, iconic), XtRImmediate, (XtPointer)False}
};
static XrmOptionDescRec wxAppOptions[] = {
    { "-debugEvents", "*debugEvents", XrmoptionNoArg,  "TRUE" },
    { "-debugOutput", "*debugOutput", XrmoptionNoArg,  "TRUE" },
    { "-debugMemory", "*debugMemory", XrmoptionNoArg,  "TRUE" },
    { "-geometry",    ".geometry",    XrmoptionSepArg,  NULL  },
    { "-iconic",      ".iconic",      XrmoptionNoArg,  "TRUE" }
};

//-----------------------------------------------------------------------------
// wxApp implementation
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxApp, wxObject)

// references to global data for compatibility
Bool & wxApp::wantDebugOutput = wxAPP_DEBUGOUTPUT;
char*& wxApp::wx_class        = wxAPP_CLASS;
char*& wxApp::appName         = wxAPP_NAME;
int&   wxApp::printMode       = wxAPP_PRINTMODE;

wxApp::wxApp(wxlanguage_t language)
{
    __type = wxTYPE_APP;

    // no application and/or application not initialized
    initialized = FALSE;
    exit_on_frame_delete = TRUE;
    init_frame = NULL;
    wxTheApp = this;
    wxSetLanguage(language);
}

wxWindow* wxApp::GetTopWindow(void)
{
    return (wxWindow*)(wxTopLevelFrames.First()->Data());
}

void wxApp::Dispatch(void)
{
    // The problem with XtAppNextEvent is that it automatically dispatches
    // timers and alternate inputs and then stalls for an X event. If the
    // only thing pending was alternate input, a wxYield() could stall.
    // XtAppProcessEvent does what we want:
    XtAppProcessEvent(wxAPP_CONTEXT, XtIMAll);
}
    
int wxApp::MainLoop(void)
{
    XEvent event;
    keep_going = TRUE;
    while (keep_going) {
	XtAppNextEvent(wxAPP_CONTEXT, &event);
#if WXDEBUG_EVENTS
	if (wxAPP_DATA.debugEvents) {
	    // print widgetname and event number
	    Widget w; int type = event.xany.type;
	    static char* event_name[] = {
		"", "unknown(-)",                                         // 0-1
		"KeyPress", "KeyRelease", "ButtonPress", "ButtonRelease", // 2-5
		"MotionNotify", "EnterNotify", "LeaveNotify", "FocusIn",  // 6-9
		"FocusOut", "KeymapNotify", "Expose", "GraphicsExpose",   // 10-13
		"NoExpose", "VisibilityNotify", "CreateNotify",           // 14-16
		"DestroyNotify", "UnmapNotify", "MapNotify", "MapRequest",// 17-20
		"ReparentNotify", "ConfigureNotify", "ConfigureRequest",  // 21-23
		"GravityNotify", "ResizeRequest", "CirculateNotify",      // 24-26
		"CirculateRequest", "PropertyNotify", "SelectionClear",   // 27-29
		"SelectionRequest", "SelectionNotify", "ColormapNotify",  // 30-32
		"ClientMessage", "MappingNotify",                         // 33-34
		"unknown(+)"};                                            // 35
	    type = wxMin(35, type); type = wxMax(1, type);
	    w = XtWindowToWidget(event.xany.display, event.xany.window);
	    printf("%-17s: %s(%p)\n", event_name[type], (w ? XtName(w) : "unknown"), w);
	    fflush(stdout);
	}
#endif
	XtDispatchEvent(&event);
	wxPostDeletion();
    }
    return 0;
}

Bool wxApp::Pending(void)
{
    XFlush(wxAPP_DISPLAY);
    return(XtAppPending(wxAPP_CONTEXT));
}

//-----------------------------------------------------------------------------
// The main function 
//-----------------------------------------------------------------------------

static void wxCommonInit(void);
static void wxCommonCleanUp(void);

/*
 * First a few comments on memory debugging.
 * - The Xt port traces ALL new and delete commands - for wxObjects and for
 *   NON-Objects. This produces some problems with global allocated memory
 *   e.g. char *buffer = new char[amount] outside any function or class.
 *   Therefore all memory before setting the application checkpoint is traced
 *   even if memory debugging is not needed.
 * - To avoid problems on deleting this memory, every wxDebugFree checks, if
 *   it frees one of this "global" pointers and uses the traced delete even if
 *   debug mode is off.
 * - The User may switch the "normal" memory tracing by the command line option
 *   "-debugMemory".
 * - The debug mode is NOT switched back to TRUE at application exit, since all
 *   pointers are stored in a list that secures the correct version of deleting.
 */

int wxEntry(int argc, char *argv[])
{
    if (!wxTheApp) {
	wxFatalError("You have to define an instance of wxApp!");
    }

    // init private and public data
    if (!wxAPP_CLASS) wxAPP_CLASS = argv[0];
    if (!wxAPP_NAME)  wxAPP_NAME  = argv[0];

    wxAPP_TOPLEVEL = XtAppInitialize(
	&wxAPP_CONTEXT, wxAPP_CLASS,
	wxAppOptions, XtNumber(wxAppOptions),	// resource options
	&argc, argv,				// command line arguments
	NULL,					// fallback resources
	NULL, 0);				// argument override for app-shell

    // standard command line options  
    XtGetApplicationResources(wxAPP_TOPLEVEL, 
			      &wxAPP_DATA, 
			      wxAppResources, 
			      XtNumber(wxAppResources), 
			      NULL, 
			      0);
    wxAPP_DEBUGOUTPUT = wxAPP_DATA.debugOutput;
    wxAPP_DEBUGEVENTS = wxAPP_DATA.debugEvents;
    wxAPP_GEOMETRY    = wxAPP_DATA.geometry;
    wxAPP_ICONIC      = wxAPP_DATA.iconic;

#if WXDEBUG && USE_MEMORY_TRACING
    // Set application checkpoint. Don't check global allocated data
    wxDebugContext::SetAppCheckpoint();
    // set if new and delete should be traced
    wxDebugContext::SetDebugMode(wxAPP_DATA.debugMemory);
#endif

    wxTheApp->argc = argc;
    wxTheApp->argv = argv;

    // initialize global data
    wxCommonInit();

    // initialize first top_level_frame
    if ( (wxTheApp->init_frame = wxTheApp->OnInit()) )
	wxTheApp->initialized = TRUE;

    // if top_level_frame start main loop
    if (wxTheApp->Initialized())
	wxTheApp->MainLoop();

    // exit application if keep_going == False
    int retval = wxTheApp->OnExit();

    // destroy global data
    wxCommonCleanUp();

#if WXDEBUG && USE_MEMORY_TRACING
    // display unfreed data
    if (wxAPP_DATA.debugMemory) {
	// reset checkpoint to value stored at start of wxEntry (main)
	wxDebugContext::SetAppCheckpoint(FALSE);
	TRACE("                    +++++++++++++++++++++++++++++\n"
	      "                    +++ Application Exit Dump +++\n"
	      "                    +++++++++++++++++++++++++++++\n\n");
	TRACE("----------------- Dump of non-global allocated data -----------------\n\n");
	wxDebugContext::Dump();
	TRACE("------------- Staticstics of non-global allocated data --------------\n\n");
	wxDebugContext::PrintStatistics();
	// reset checkpoint to value stored at start of wxEntry (main)
	wxDebugContext::SetCheckpoint(TRUE);
	TRACE("--------------------- Dump of all allocated data --------------------\n\n");
	wxDebugContext::Dump();
	TRACE("------------------ Statistics of all allocated data -----------------\n\n");
	wxDebugContext::PrintStatistics();
	TRACE("------------------------------- done --------------------------------\n\n");
    }
#endif

    // return properly
    return (retval);
}
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------

class wxModule : public wxObject {
public:
    wxModule(void (*in)(void*), void (*ex)(void*), void* ar) {
	init = in; exit = ex; arg = ar;
    }
    ~wxModule() {}
    void Init() { init(arg); }
    void Exit() { exit(arg); }
private:
    void (*init)(void*);
    void (*exit)(void*);
    void* arg;
};

static wxList *wxModules = 0;

void wxRegisterModule(void (*init)(void*), void (*exit)(void*), void* arg)
{
    if(!wxModules)
	wxModules = new wxList;
    wxModules->Append(new wxModule(init, exit, arg));
}

//-----------------------------------------------------------------------------
// initialize and destroy global data
//-----------------------------------------------------------------------------

void wxCommonInit(void)
{
    // terminate wxBuffer with 0
    wxBuffer[wxBufferSize]='\0';

    // initialize class pointers to speed up IsKindOf
    wxClassInfo::InitializeClasses();

    wxAPP_DISPLAY   = XtDisplay(wxAPP_TOPLEVEL);
    wxAPP_SCREEN    = XtScreen(wxAPP_TOPLEVEL);
    wxAPP_ROOT	    = RootWindow(wxAPP_DISPLAY, DefaultScreen(wxAPP_DISPLAY));

    wxAPP_COLOURMAP = wxNEW wxColourMap(FALSE); // default colourmap

    wxInitializePrintSetupData();
    wxThePrintPaperDatabase = wxNEW wxPrintPaperDatabase;
    wxThePrintPaperDatabase->CreateDatabase();

    (void)wxNEW wxColourDatabase();
    (void)wxNEW wxGDIList();
    (void)wxNEW wxFontNameDirectory();
    (void)wxNEW wxFontList();
    (void)wxNEW wxPenList();
    (void)wxNEW wxBrushList();

    // Initialize user-defined modules
    if (wxModules)
	for (wxNode* node = wxModules->First(); node; node = node->Next()) {
	    ((wxModule*)(node->Data()))->Init();
	}
}

void wxCommonCleanUp(void)
{
    // Cleanup user-defined modules
    if (wxModules) {
	for (wxNode* node = wxModules->Last(); node; node = node->Previous()) {
	    ((wxModule*)(node->Data()))->Exit();
	    delete (wxModule*)(node->Data());
	}
	delete wxModules;
    }

#if USE_WX_RESOURCES
    // has to be cleared here, because it interferes with the destruction of wxTheBitmapList
    wxDefaultResourceTable.ClearTable();
#endif
    // GDI classes
    delete wxTheBrushList;	   // delete all brushes from list
    delete wxThePenList;	   // delete all pens form list
    delete wxTheFontList;	   // delete all fonts from list
    delete wxTheFontNameDirectory; // delete all font names
    delete wxTheBitmapList;	   // delete all bitmaps, cursors, and icons from list
    delete wxTheColourDatabase;	   // delete all colours from database
    // print setup and paper database
    wxInitializePrintSetupData(FALSE);
    delete wxThePrintPaperDatabase;
    wxThePrintPaperDatabase = NULL;
#if USE_TYPETREE
    // clear type tree
    wxAllTypes.Clear();
#endif
    // delete colourmap
    delete wxAPP_COLOURMAP;

#if USE_RESOURCES
    //extern void wxFlushResources(void); // Defined in Utilities/wxResUtil.cxx
    //wxFlushResources();
#endif
}

