/*								-*- C++ -*-
 * $Id: UTL_postdelete.cpp,v 1.1 1996-09-25 11:32:01+02 mho Exp $
 *
 * Purpose: delete object AFTER event was handled
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#define  Uses_wxList
#include "wx.h"

//-----------------------------------------------------------------------------
// wxPostDelete: delete after event was handled
//-----------------------------------------------------------------------------

// added by steve, 04.01.95
//
// a safer method for killing objects from methods of this
// objects:
// instead of calling 'delete this' in a method, you can
// use the 'wxPostDelete(this)' function. it inserts the
// object into a list, which is processed after the current event
// has been processed.
// 
// !!!! interestingly this doesn't work well for the MAIN FRAME !!!!
// therefore: DON'T DELETE THE MAIN FRAME WITH 'wxPostDelete' 
//
// this adds only a very small overhead to the event handling loop
//
// if you call 'delete this' from a menubar function, the
// widget is destroyed before the callback function is completed.
// under VMS this leads to a crash.
//

static Bool somethingToDelete = FALSE;
wxList wxPostDeleteList;

// this function can be used by the application
void wxPostDelete(wxObject *object)
{
    wxPostDeleteList.Append(object);
    somethingToDelete = TRUE;
}

// process the list and delete objects (used in main loop)
void wxPostDeletion(void)
{
    if(somethingToDelete) {
	wxNode *node = wxPostDeleteList.First();
	while(node!=NULL) {
	    wxObject *object = (wxObject *)node->Data();
	    delete object;
	    delete node;
	    node = wxPostDeleteList.First();
	}
	somethingToDelete = FALSE;
    }
}
