#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>

#include <sys/types.h>
#include <sys/socket.h>

#include <netdb.h>	/* For gethostbyname(). */
extern int h_errno;

#include <netinet/in.h>

#include <Y2/Y.h>
#include <Y2/Ylib.h>

#include "../include/string.h"


#ifndef DEF_CON_ARG
# define DEF_CON_ARG    "127.0.0.1:9433"
#endif            



/*
 *	Print help.
 */
void PrintUsage()
{
	printf("\
Usage: yhost [-] <address> [options]\n\
\n\
    Specifying a `-' argument means to remove the <address>.\n\
\n\
    <address> is the numeric IP or named address of the host you\n\
    want to allow/disallow access to the YIFF server.\n\
    This command must be runned on the same physical computer as\n\
    the YIFF server is running on.\n\
\n\
    [options] can be any of the following:\n\
\n\
        --recorder <address:port>    Specify which YIFF server to connect to.\n\
\n"
	);


	return;
}


int main(int argc, char *argv[])
{
	int i, status;

	char *con_arg = NULL;

	int op = 1;

	YConnection *con = NULL;
	YIPUnion ip;

	struct hostent *he;
        struct sockaddr_in haddr;


	if(argc < 2)
	{
	    PrintUsage();
	    return(1);
	}


	/* Parse arguments. */
	for(i = 1; i < argc; i++)
	{
	    if(argv[i] == NULL)
		continue;

	    /* Help. */
	    if(strcasepfx(argv[i], "--h") ||
               strcasepfx(argv[i], "-h") ||
               !strcmp(argv[i], "?")
	    )
	    {
		PrintUsage();
		return(0);
	    }

	    /* Add or remove? */
	    if(i == 1)
	    {
		if(!strcmp(argv[i], "-"))
		{
		    op = 0;	/* We know it's remove, continue. */
		    continue;
		}
		else if(!strcmp(argv[i], "+"))
		{
		    op = 1;	/* We know it's add, continue. */
                    continue;
		}
		else
		{
		    op = 1;
		}
	    }

	    /* Address. */
	    if((i == 1) ||
               (i == 2)
            )
	    {
		/* Parse address. */
		he = gethostbyname(argv[i]);
		if(he == NULL)
		{
		    switch(h_errno)
		    {
                      case NO_ADDRESS:
                        fprintf(stderr,
                            "%s: No associated IP address.\n",
                            argv[i]
                        );
                        break;

                      case NO_RECOVERY:
                        fprintf(stderr,
                            "%s: Unrecoverable error.\n",
                            argv[i]
                        );
                        break;

                      case TRY_AGAIN:
                        fprintf(stderr,
                            "%s: Name server unavailable.\n",
                            argv[i]
                        );
                        break;

                      default:
                        fprintf(stderr,
                            "%s: Unknown host.\n",
                            argv[i]
                        );
                        break;
		    }

		    free(con_arg);
		    con_arg = NULL;

		    return(1);
		}

		haddr.sin_addr = *((struct in_addr *)he->h_addr);
		ip.whole = (u_int32_t)haddr.sin_addr.s_addr;

		continue;
	    }

	    /* Connect address. */
	    if(strcasepfx(argv[i], "--rec") ||
               strcasepfx(argv[i], "-rec")
	    )
	    {
		i++;
		if(i < argc)
		{
		    free(con_arg);
		    con_arg = StringCopyAlloc(argv[i]);
		}
		else
		{
		    fprintf(stderr,
			"%s: Requires argument.\n",
			argv[i - 1]
		    );
		}
	    }
	}


	/*
	 *	Connect to YIFF server.
	 */
	con = YOpenConnection(
	    NULL,		/* No start argument. */
	    con_arg
	);
	if(con == NULL)
	{
	    printf("%s: Cannot connect to YIFF server.\n",
		(con_arg == NULL) ? DEF_CON_ARG : con_arg
	    );

            free(con_arg);
            con_arg = NULL;

	    return(-1);
	}


	/*
	 *	Add or remove host.
	 */
	if(op)
	    status = YAddHost(con, &ip);
	else
	    status = YRemoveHost(con, &ip);        

	if(status)
            printf("Cannot %s %i.%i.%i.%i.\n",
		(op == 0) ? "remove" : "add",
                ip.charaddr[0],
                ip.charaddr[1],
                ip.charaddr[2],
                ip.charaddr[3]
            );
	else
            printf("%s %i.%i.%i.%i %s host access list.\n",
                ((op == 0) ? "Removing" : "Adding"),
                ip.charaddr[0],
                ip.charaddr[1],
                ip.charaddr[2],
                ip.charaddr[3],
		((op == 0) ? "from" : "to")
            );

	/*
	 *	Disconnect from YIFF server
	 */
	YCloseConnection(con, False);
	con = NULL;

	free(con_arg);
	con_arg = NULL;



	return(0);
}
