C  -------------------------------------------------------------------
C
C	Copyright (1990-1995) by Alexander Khibnik, Yuri Kuznetsov, and 
C	Eugene Nikolaev.
C
C The Locbif computation code in DsTool is distributed in the hope that it  
C will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty  
C of FITNESS FOR A PARTICULAR PURPOSE.  The software is provided as is without 
C any obligation on the part of Locbif authors, Cornell faculty, 
C Cornell staff or Cornell students to assist in its use, correction, 
C modification or enhancement. 
C
C  -------------------------------------------------------------------

        SUBROUTINE TANGNT(NX,NDIMM,NFIX,XTNG,FTNG,VTNG,FUN,DFDX,DFUN,
     A                    IER,ISTOP)
C       3.05.90.
C       31.07.1991
C       13.11.92
C       15.06.94
C* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C*                                                                     *
C*    POPAMMA  TANGNT  PEHAHAEHA  HAXOEH BEKTOPA          *
C*    EHHO H - VTNG, KACATEHOO K KPBO : FUN(X)=0         *
C*    B TOKE XTNG.                                                    *
C*    PEOAAETC, TO B KAECTBE APAMETPA HA KPBO BPAHA       *
C*    NFIX-KOMOHEHTA BEKTOPA X: X(NFIX).                              *
C*    KACATEH BEKTOP OPEHTPETC TAK, TO BEHE O KACATE-*
C*    HOM BEKTOP COOTBETCTBOBAO BOPACTAH APAMETPA, T.E.         *
C*    BCEA BOHETC HEPABEHCTBO: VTNG(NFIX) GT. 0.D0              *
C*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . .*
C*                                                                     *
C*    APAMETP:                                                       *
C*    =========                                                        *
C*    NX   - CO EPEMEHHX;                                         *
C*    NDIM - ABEHHA CTPOHA PAMEPHOCT MATP DFUN;             *
C*    NFIX - HOMEP KCPOBAHHO EPEMEHHO;                           *
C*    XTNG - MACCB KOOPHAT TOK HA KPBO, B KOTOPO BCETC   *
C*           KACATEH BEKTOP.                                       *
C*    FTNG - ARRAY FOR FUNCTION VALUES                                 *
C*    VTNG - MACCB KOOPHAT KACATEHOO BEKTOPA.                    *
C*    FUN  - M POPAMM BCEH APBX ACTE - F(X).            *
C*    DFDX - M POPAMM BCEH MATP ACTHX POBOHX.     *
C*    DFUN - BMEPH MACCB PAMEPHOCT  NDIM*NX, COEPA         *
C*           MATP EPBX ACTHX POBOHX;                       *
C*    IER  - APAMETP OK:                                          *
C*              0 - KACATEH BEKTOP CEHO HAEH;                 *
C*             -1 - HEHA CCTEMA PABHEH, OPEEA           *
C*                  KACATEH BEKTOP - BPOEHA;                    *
C*             -2 - HE BCEH HAEH HK B TOKE  XTNG;       *
C*             -3 - HE BCEH POBOHE B TOKE       XTNG;       *
C* . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . . *
C*                                                                     *
C*    BBAEME POPAMM: DERN, FUN, JACOB.                          *
C* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C*    P HEOXOMOCT MEHEH MAKCMAHOO CA NDIM             *
C*    EPEMEHHX, CEET MEHT PAMEPHOCT MACCBA A(NDIM,NDIM),   *
C*                                                   ARR1(NDIM,NDIM)   *
C* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
C
      IMPLICIT REAL*8 (A-H,O-Z)
      IMPLICIT INTEGER*2 (I-N)
      include 'beetlebf.dim'
      EXTERNAL FUN, DFDX
      DIMENSION XTNG(1), FTNG(1), VTNG(1), DFUN(NDIM,NX)
C
      COMMON /WORKBE/ ARR1(NDIM,NDIM), A(NDIM,NDIM)
C
C.... BCEM HAEH HK F(X) B TOKE XTNG;
C     BCEHHE HAEH PAMEATC B MACCBE  VTNG.
C
      ISTOP = 0
      IER   = 0
      CALL FUN (XTNG,FTNG,IER,ISTOP)
      IF (ISTOP .NE. 0) RETURN
      IF (IER   .EQ. 0) GOTO 102
          IER = -2
          RETURN
 102  CONTINUE
C
C.... BCEM MATP ACTHX POBOHX.
C
      DO 200 J=1,NX
         DFUN(NX,J) = 0.D0
 200  CONTINUE
      DFUN(NX,NFIX) = 1.D0
      IER = 0
      CALL JACOB (NX,NDIM,XTNG,FUN,DFDX,DFUN,FTNG,IER,ISTOP)
      IF (ISTOP .NE. 0) RETURN
      IF (IER   .EQ. 0) GOTO 215
          IER =-3
          RETURN
 215  CONTINUE
C
C.... OPMPEM BEKTOP PABX ACTE (VTNG)  MATP (A).
C
      DO 255 I=1,NX
         VTNG(I) = 0.0D0
         DO 250 J = 1,NX
            A(I,J) = DFUN(I,J)
 250     CONTINUE
 255  CONTINUE
      VTNG(NX)  = 1.D0
C
C.... PEAEM CCTEM HEHX PABHEH  A*Y=VTNG;
C
      IER = 0
      CALL LEQV (A,VTNG,NDIM,NX,IER)
      IF (IER .EQ. 0) GOTO 260
C
C.... MATPA  DFUN - BPOEHA.
C
          IER = -1
          RETURN
 260  CONTINUE
C
C.... HOPMPEM H KACATEHOO BEKTOPA  VTNG  HA EH.
C
      DLEN = 0.D0
      DO 360 I = 1,NX
        ELEM = VTNG(I)
        DLEN = DLEN + ELEM*ELEM
 360  CONTINUE
      DLEN = DSQRT(DLEN)
      DO 380 I = 1,NX
        VTNG(I) = VTNG(I)/DLEN
 380  CONTINUE
      IER = 0
      RETURN
      END
