/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/* 
 * symbols.h
 */

#ifndef SYMBOLS_HEADER
#define SYMBOLS_HEADER

#include <constants.h>

/* symbol and size definitions used by the print library */

extern int	Symbol_Codes[]; 
extern char	*Symbol_Labels[];
extern int	Num_Symbols; 

/* symbol and size definitions used by the 2D graphics library */

extern char	*Panel_Sym_Names[]; 

typedef enum {
  SMALL_POINT=0, MED_POINT, LARGE_POINT,
  SMALL_CROSS, MED_CROSS, LARGE_CROSS,
  SMALL_BOX, MED_BOX, LARGE_BOX,
  SMALL_TRI, MED_TRI, LARGE_TRI,
  NUM_SYM_TYPES
} SYMBOLS_t;

#define NUM_SYM_SIZES 3

#define SYS_RED 0
#define SYS_GREEN 1
#define SYS_BLUE 2

#define N_SYS_COLORS 3

#define N_CONT_COLORS 4

/* Color indices into Color.Cont_Colors */
#define SNB_COLOR 0
#define RSNB_COLOR 1
#define HB_COLOR 2
#define DHB_COLOR 3

/* Old symbol/size defs for compatibility with DsTool 2.0  -- 7/6/97 BAM */
/* constants for the symbol objects */
#define         OLD_NUM_SYM_SIZES           4
#define         OLD_NUM_SYM_TYPES           4
 
#define         OLD_SMALL_POINT             1
#define         OLD_MED_POINT               2
#define         OLD_LARGE_POINT             3
#define         OLD_HUGE_POINT              4
#define         OLD_SMALL_TRI               5
#define         OLD_MED_TRI                 6
#define         OLD_LARGE_TRI               7
#define         OLD_HUGE_TRI                8
#define         OLD_SMALL_CROSS             9
#define         OLD_MED_CROSS               10
#define         OLD_LARGE_CROSS             11
#define         OLD_HUGE_CROSS              12
#define         OLD_SMALL_BOX               13
#define         OLD_MED_BOX                 14
#define         OLD_LARGE_BOX               15
#define         OLD_HUGE_BOX                16
 
/* constants for the system colors */
#define         OLD_SYS_RED                 3
#define         OLD_SYS_GREEN               4
#define         OLD_SYS_BLUE                5
 
#endif
