/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * decode_cmd.c
 */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "pm.h"
#include "constants.h"
#include "defaults.h"
#include "version.h"
#include "utilities.h"
#include "init_local.h"


/*
 * procedure to decode the command line arguments
 *
 * It accepts:
 *    -infile FILENAME
 *    -outfile FILENAME
 *    -debug
 *    -version
 *    -large
 *
 * All the command line arguments are stored in the postmaster.
 * This stuff must all be retrieved from tcl.
 */
#include <tcl.h>
extern Tcl_Interp *interp;

void
decode_cmd_line()
{
  int i, argc;
  char *name, **argv, buf[MAX_CMD_LINE_ARG_LEN];


  /* find argc and initialize pm */
  sprintf(buf, "set argc");
  tcl_script(buf);
  argc = atoi(interp->result)+1;
  pm(PUT, "Control.Argc", argc,
     INIT, "Control.Argv", argc, MAX_CMD_LINE_ARG_LEN, NULL);
  argv = calloc(argc, sizeof(char *));

  /* find name of executable and save to pm */
  sprintf(buf, "set argv0");
  tcl_script(buf);
  name = ( (name = strrchr(interp->result,'/')) != (char *) NULL) ? 
    name+1 : interp->result;
  pm(INIT, "Control.Program_Name", strlen(name)+1,
     PUT, "Control.Program_Name", name,
     PUT, "Control.Argv", 0, interp->result,
     NULL);

  /* copy argc and argv into postmaster */
  sprintf(buf, "set argv");
  tcl_script(buf);
  name = interp->result;
  for (i=1; i<argc; i++)
    {
     argv[i] = name;
     name = strrchr(name,' ');
     if (name != NULL) *(name++)='\0';
     pm(PUT, "Control.Argv", i, argv[i], NULL);
   }

  /* find out the mode from examining the command line and 
     look for control files */
  for(i=1; i<argc; i++)
    {
      
      if (!strcmp(argv[i],"-infile"))           /* INPUT FILE FLAG */
	{
	  if ( (++i == argc) || !check_file_to_read(argv[i]) )
	    {
	      fprintf(stderr,
		"dstool: configuration path or file cannot be read.\n");
	      stop_execution(USAGE_STR);
	    }
	  else
	    {
	      pm(INIT, "Control.Infile", strlen(argv[i])+1,
		 PUT, "Control.Infile", argv[i], NULL);
	    }
	}
 
      else if (!strcmp(argv[i],"-outfile"))      /* OUTPUT FILE FLAG */
	{
	  if ( (++i == argc) || !check_file_to_write(argv[i]) )
	    {
	      fprintf(stderr,
		"dstool: configuration path or file cannot be written.\n");
	      stop_execution(USAGE_STR);
	    }
	  else
	    {
	      pm(INIT, "Control.Outfile", strlen(argv[i])+1,
		 PUT, "Control.Outfile", argv[i], NULL);
	    }
	}
 
      else if (!strcmp(argv[i],"-large"))              /* LARGE FLAG */
	pm(PUT, "Control.Large", TRUE, NULL);

      else if (!strcmp(argv[i],"-debug"))              /* DEBUG FLAG */
	pm(PUT, "Control.Debug", TRUE, NULL);

      else if (!strcmp(argv[i],"-version"))         /* VERSIONS FLAG */
	stop_execution(VERSION);

      else if (!strcmp(argv[i],"-help"))         /* HELP FLAG */
	stop_execution(USAGE_STR);

    }

  free(argv);
}
