/*
The DsTool program is the property of:
 
                             Cornell University 
                        Center of Applied Mathematics 
                              Ithaca, NY 14853
                      dstool_bugs@macomb.tn.cornell.edu
 
and may be used, modified and distributed freely, subject to the following
restrictions:
 
       Any product which incorporates source code from the DsTool
       program or utilities, in whole or in part, is distributed
       with a copy of that source code, including this notice. You
       must give the recipients all the rights that you have with
       respect to the use of this software. Modifications of the
       software must carry prominent notices stating who changed
       the files and the date of any change.
 
DsTool is distributed in the hope that it will be useful, but WITHOUT ANY 
WARRANTY; without even the implied warranty of FITNESS FOR A PARTICULAR PURPOSE.
The software is provided as is without any obligation on the part of Cornell 
faculty, staff or students to assist in its use, correction, modification or
enhancement.
*/

/*
 * init_local.h
 */

#ifndef INIT_LOCAL_h
#define INIT_LOCAL_h

#include <tcl.h>

typedef void (*PFV)(void);

/* dstool_init.c */
void dstool_init(void);

/* app_init.c */
int app_init(Tcl_Interp *tcl_interp);

/* decode_cmd.c */
void decode_cmd_line(void);

/* stop.c */
void stop_execution(char *s);

/* sys_install.c */
void sys_install(void);
void user_install(void);


void model_install(void);
void selected_install(void);
void manifold_install(void);
void memory_install(void);
void flow_install(void);
void prop_install(void);
void color_install(void);
void mult_install(void);
void browser_install(void);
void fixed_install(void);
void porbit_install(void);
void defaults_install(void);
void geomview_install(void);
void parser_install(void);
void save_install(void);
void load_install(void);
void view_install(void);
void print_install(void);
void control_install(void);

/* 8/19/97 BAM */
void cont_install(void);
void twod_install(void);


/*
void oned_install(void);
*/

#endif /* !INIT_LOCAL_h */
