/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef HG4DEF
#define HG4DEF

typedef float Hg4Coord;
typedef Hg4Coord Hg4Tensor1[4];
typedef Hg4Coord Hg4Tensor2[4][4];

#define TMX 0
#define TMY 1
#define TMZ 2
#define TMW 3

/* Tensor of Order 1 */
extern char *Hg4Create();
extern void Hg4Delete(/* Hg4Tensor1 p */);

extern void Hg4Print(/* Hg4Tensor1 p */);
extern void Hg4From(/* Hg4Tensor1 p, Hg4Coord x, y, z, w */);
extern void Hg4Copy(/* Hg4Tensor1 a, b */);

extern int Hg4Compare(/* Hg4Tensor1 a, b */);
extern int Hg4Coincident(/* Hg4Tensor1 a, b */);
extern int Hg4Undefined(/* Hg4Tensor1 a */);
extern int Hg4Infinity(/* Hg4Tensor1 a, int dual */);

extern void Hg4Normalize(/* Hg4Tensor1 a, b */);
extern void Hg4Pencil(
    /* Hg4Coord t1, Hg4Tensor1 p1, Hg4Coord t2, Hg4Tensor1 p2, p*/);

extern void Hg4Transform(/* Transform t, Hg4Tensor1 p1, p2 */);

/* Tensor of Order 2 */
extern void Hg4Print2(/* Hg4Tensor2 a */);
extern void Hg4Copy2(/* Hg4Tensor2 a, b */);

extern int Hg4Compare2(/* Hg4Tensor2 a, b */);
extern int Hg4Undefined2(/* Hg4Tensor2 a */);
extern int Hg4Infinity2(/* Hg4Tensor2 a, int dual */);

extern void Hg4Transform2(/* Transform3 T, Hg4Tensor2 a, b */);

extern void Hg4AntiProductPiQi(/* Hg4Tensor2 p12, Hg4Tensor1 p1, p2 */);
extern Hg4Coord Hg4ContractPiQi(/* Hg4Tensor1 p1, p2 */);
extern void Hg4AntiContractPijQj(/* Hg4Tensor2 a, Hg4Tensor1 p1, p2 */);
extern void Hg4ContractPijQjk(/* Hg4Tensor2 a, b, c */);
extern Hg4Coord Hg4ContractPii(/* Hg4Tensor2 a */);

extern int Hg4Intersect2(/* Hg4Tensor2 a, Hg4Tensor1 b, c */);
extern int Hg4Intersect3(/* Hg4Tensor1 a, b, c, p, int dual */);
extern int Hg4Intersect4(/* Hg4Tensor2 a, b, Hg4Tensor1 pl, pt */);

extern void Hg4Dual(/* Hg4Tensor2 L, K */);

#endif
