#include "mibload.h"
#include "../common/drawer.h"
#include "gvui.h"
static /* prefix to ``char Root[]...'' */
#include "interface/Input.mib"

extern Display *dpy;
extern Widget TopLevel;

/* private methods and variables */
/*****************************************************************************/

static Widget shell, loadform;
static Widget FileBrowserButton, HideButton, OKButton, TextField;
static int loaded = 0, shown = 0;
static char **dirp;
static int    pos_later = 0, posx = 0, posy = 0;
static char geometry[40];

static void do_load(Widget w, XtPointer data, XmAnyCallbackStruct *cbs);
static void action_load(Widget, XEvent *, String *, Cardinal *);
static XtActionsRec actions[1] = { "GVLoad", action_load };
static String loadtransl = "<KeyPress>Return: GVLoad()";
/*****************************************************************************/

void ui_load_loadpanel()
{
  Arg	     args[20];
  int	     n;
  mib_Widget *loadload;
  XtTranslations LoadTransl;
  static char Load[] = "Load";

/*****************************************************************************/

  XtAppAddActions(App, actions, 1);

  shell = ui_make_panel_and_form(Load, Root, False,
		&loadform);

/*loadload = mib_load_interface(loadform, "interface/MiniLoad.mib",
                MI_FROMFILE);*/
  loadload = mib_load_interface(loadform, Root,
                MI_FROMSTRING);
 
  XtManageChild(loadform);

  FileBrowserButton = mib_find_name(loadload, "FileBrowser")->me;
  HideButton =        mib_find_name(loadload, "Cancel")->me;
  OKButton =          mib_find_name(loadload, "OK")->me;
  TextField =         mib_find_name(loadload, "FileName")->me;


  XtAddCallback(HideButton, XmNactivateCallback, (XtCallbackProc)ui_hide,
		(XtPointer) Load);
  XtAddCallback(OKButton, XmNactivateCallback, (XtCallbackProc)do_load,
		(XtPointer) NULL);
  XtAddCallback(FileBrowserButton, XmNactivateCallback,
			(XtCallbackProc)ui_show,
			(XtPointer)"Files");

  XtVaSetValues(TextField, XmNblinkRate, 0, NULL);

  LoadTransl = XtParseTranslationTable(loadtransl);
  XtOverrideTranslations(TextField, LoadTransl);

  loaded = 1;
}


/*****************************************************************************/

void ui_show_loadpanel()
{
  char *str;
  Window root, child;
  int x, y, wx, wy, posx, posy;
  unsigned int mask;

  XtManageChild(loadform);

  if(XQueryPointer(dpy, DefaultRootWindow(dpy), &root, &child,
		&x, &y, &wx, &wy, &mask)) {
	posx = (x -= 20) < 0 ? 0 : x;
	posy = (y -= 20) < 0 ? 0 : y;
  }
  XtMoveWidget(shell, posx, posy);

  XtSetMappedWhenManaged(loadform, True);
  XtRealizeWidget(shell);
  XRaiseWindow(dpy, XtWindow(shell));
  XtSetKeyboardFocus(loadform, TextField);

  XmTextFieldSetSelection(TextField, 0, 9999, last_event_time);
}

/*****************************************************************************/

static void do_load(Widget w, XtPointer data, XmAnyCallbackStruct *cbs)
{
  char *str = XmTextGetString(TextField);
  if(str != NULL && str[0] != '\0')
    gv_load( str, NULL );
  ui_hide(w, "Load", NULL);
}


static void action_load(Widget w, XEvent *event, String *argv, Cardinal *argc)
{
  do_load(w, NULL, NULL);
}
