/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */
static char *copyright = "Copyright (C) 1992 The Geometry Center";

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "color.h"
#include <stdlib.h>

void
CoPrint( Color *c )
{
}

void
CoCopy( Color *c1, Color *c2 )
{
    *c2 = *c1;
}

void
CoACopy( ColorA *c1, ColorA *c2 )
{
    *c2 = *c1;
}

void
CoFrom( Color *c, float r, float g, float b )
{
    c->r = r;
    c->g = g;
    c->b = b;
}

void
CoAdd( Color *c1,Color *c2, Color *c3 )
{
    c3->r = c1->r + c2->r;
    c3->g = c1->g + c2->g;
    c3->b = c1->b + c2->b;
}

void
CoSub( Color *c1, Color *c2, Color *c3 )
{
    c3->r = c1->r - c2->r;
    c3->g = c1->g - c2->g;
    c3->b = c1->b - c2->b;
}
void
CoFilter( Color *c1, Color *c2, Color *c3 )
{
    c3->r = c1->r * c2->r;
    c3->g = c1->g * c2->g;
    c3->b = c1->b * c2->b;
}


#define vH (hsv->r)
#define vS (hsv->g)
#define vV (hsv->b)

/* HSV to RGB conversion from Ken Fishkin, pixar!fishkin */
void hsv2rgb(Color *hsv, Color *rgb)
{
    float h = 6.0 * (vH < 0 ? vH + (1 - (int)vH) : vH - (int)vH);
    int sextant = (int) h; /* implicit floor */
    float fract = h - sextant;
    float vsf = vS*vV*fract;
    float min = (1-vS)*vV;
    float mid1 = min + vsf;
    float mid2 = vV - vsf;
    switch (sextant%6) {
    case 0: rgb->r = vV;   rgb->g = mid1; rgb->b = min; break;
    case 1: rgb->r = mid2; rgb->g = vV;	  rgb->b = min; break;
    case 2: rgb->r = min;  rgb->g = vV;	  rgb->b = mid1; break;
    case 3: rgb->r = min;  rgb->g = mid2; rgb->b = vV; break;
    case 4: rgb->r = mid1; rgb->g = min;  rgb->b = vV; break;
    case 5: rgb->r = vV;   rgb->g = min;  rgb->b = mid2; break;
    }
}

void rgb2hsv(Color *rgb, Color *hsv)
{

#define cRGB (&rgb->r)

    int min, max;
    float dv;
    if(cRGB[0] < cRGB[1])
	min = 0, max = 1;
    else
	min = 1, max = 0;
    if(cRGB[min] > cRGB[2]) min = 2;
    else if(cRGB[max] < cRGB[2]) max = 2;

    vV = cRGB[max];
    dv = cRGB[max] - cRGB[min];
    if(dv == 0) {
	vH = 0;	/* hue undefined, use 0 */
	vS = 0;
    } else {
	float dh = (cRGB[3 - max - min] - cRGB[min]) / (6*dv);
	vH = (3+max-min)%3==1 ? max/3.0 + dh : max/3.0 - dh;
	if(vH < 0) vH += 1 + (int)vH;
	if(vH > 1) vH -= (int)vH;
	vS = dv / cRGB[max];
    }
}
