/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Pat Hanrahan, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "stdio.h"
#include "transform3.h"

# define MAXSTACK 32
static int maxstack = 0;
static Transform3 stack[MAXSTACK];

void
Tm3Push( T )
    Transform3 T;
{
    if( maxstack < MAXSTACK )
        Tm3Copy( T, stack[maxstack++] );
    else
	fprintf( stderr, "Stack Overflow at 32\n" );
}

void
Tm3Pop( T )
    Transform3 T;
{
    if( maxstack > 0 ) 
        Tm3Copy( stack[--maxstack], T );
    else
	fprintf( stderr, "Stack Underflow\n" );
}

