/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef	POLYLISTDEFS
#define	POLYLISTDEFS
/*
 * Public definitions for PolyList's
 */

#include "bbox.h"

typedef struct PolyList PolyList;

extern PolyList *PolyListDraw( PolyList * );
extern BBox	*PolyListBound( PolyList *, Transform );
extern Geom 	*PolyListSphere( PolyList *, Transform, int );
extern PolyList *PolyListEvert( PolyList * );
extern PolyList *PolyListLoad( char * );	/* Loads "off" files */
extern PolyList *PolyListFLoad( FILE *, char *fname );
extern char    *PolyListName( void );
extern PolyList *PolyListSave( PolyList *, char * );
extern PolyList *PolyListFSave( PolyList *, FILE *, char * );
extern PolyList *PolyListTransform( PolyList *, Transform );
extern PolyList *PolyListTransformTo( PolyList *, Transform );

#endif/*POLYLISTDEFS*/
