/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "quadP.h"

Quad *
QuadComputeNormals( q )
Quad *q;
{
    int i;
    Point3 nor;
    float len;
    register HPoint3 *p;
    register Point3 *n;

    /*
     * Only compute if not present!
     */
    if( !(q->flag & QUAD_N) ) {
	if(q->n == NULL)
	    q->n = OOGLNewNE(QuadN, q->maxquad, "QuadComputeNormals normals");
	p = &q->p[0][0];
	n = &q->n[0][0];
	for( i = q->maxquad; --i >= 0; p += 4) {

#define  TERM(S, T)	(p[0].S - p[1].S) * (p[1].T + p[0].T) + \
			(p[1].S - p[2].S) * (p[2].T + p[1].T) + \
			(p[2].S - p[3].S) * (p[3].T + p[2].T) + \
			(p[3].S - p[0].S) * (p[0].T + p[3].T)

	    nor.x = TERM(y, z);
	    nor.y = TERM(z, x);
	    nor.z = TERM(x, y);
	    len = nor.x*nor.x + nor.y*nor.y + nor.z*nor.z;
	    if( len != 0.0 ) {
		len = 1.0 / sqrt(len);
		nor.x *= len;
		nor.y *= len;
		nor.z *= len;
	    }
	    *n++ = nor;
	    *n++ = nor;
	    *n++ = nor;
	    *n++ = nor;
	}
	q->flag |= QUAD_N;
    }
    return q;
}
