/* Copyright (C) 1999 Aaron Lehmann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */


/* #include <gmp.h> */


enum
{
  MP_ERROR_NONE,       /* No error */
  MP_ERROR_SYNTAX,     /* Syntax error */
  MP_ERROR_OOM,        /* Out of memory */
  MP_ERROR_VARIABLE,   /* Too many variables or not enough variable solutions passed */
  MP_ERROR_DIV0,       /* Division by 0 */
  MP_ERROR_SQRTNEG,    /* Square root of a negative */
  MP_ERROR_RECURSION   /* Recursion */
};



enum
{
  MP_TOKEN_CONSTANT,   /* A constant [1] */
  MP_TOKEN_CONST,      /* Predefined constant [pi] */
  MP_TOKEN_VARIABLE,   /* A variable in variables[] [X] */
  MP_TOKEN_PLUS,       /* Addition [X+Y] */
  MP_TOKEN_MINUS,      /* Subtraction [X-Y] */
  MP_TOKEN_UNARY_MINUS,/* Unary minus [-X] */
  MP_TOKEN_MULT,       /* Multiplication [X*Y] */
  MP_TOKEN_DIV,        /* Division [X/Y] */
  MP_TOKEN_FNCT,       /* Function [sin (X)] */
  MP_TOKEN_FACT,       /* Factorial [X!] */
  MP_TOKEN_POW,        /* Power of n [X^Y] */
  MP_TOKEN_ROOT        /* Root */
};


enum
{
  MP_UNIT_RADIAN,      /* Use radians */
  MP_UNIT_DEGREE       /* Use degrees */
};



struct mp_stack
{
  /* Every one of these needs a token type */
  /* value is always used for constants and used during evaluation for vars */
  /* id is used for variables. e.g. 'x' or 'y' */
  /* symboltab is used for functions and predefined constants */
  short  tokentype;
  double  value;
  char   id;
  symrec *symboltab;
  struct mp_stack *next, *previous;
};



extern double mp_eval_exp    (gdouble x, int *err                );
void          mp_push_op     (short mptoken                      );
void          mp_push_var    (char mpvar, gdouble value          );
void          mp_push_num    (double mpnum                       );
void          mp_push_fnct   (symrec *in                         );
void          mp_push_const  (symrec *in                         );
/*void          mp_set_eq      (char mpname, double value);*/
double        mp_fact        (double in                          );
extern void   init_table     (                                   );
extern void   mp_fix_stack   (void                               );
extern void   mp_stack_clean (void                               );
double        mp_sin         (double x                          );
double        mp_tan         (double x                          );
double        mp_cos         (double x                          );
double        mp_cot         (double x                          );
double        mp_csc         (double x                          );
double        mp_sec         (double x                          );
double        mp_asin        (double x                          );
double        mp_atan        (double x                          );
double        mp_acos        (double x                          );
double        mp_sinh        (double x                          );
double        mp_tanh        (double x                          );
double        mp_cosh        (double x                          );
double        mp_asinh       (double x                          );
double        mp_atanh       (double x                          );
double        mp_acosh       (double x                          );
double        mp_sign        (double x                           );
