/*
    Copyright (C) 1998  Dennis Roddeman
    email: d.g.roddeman@wb.utwente.nl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software Foundation 
    59 Temple Place, Suite 330, Boston, MA, 02111-1307, USA
*/

#include "tochnog.h"

int main( int argc, char* argv[] )

{
  long int i=0, l=0, any_point=0;
  char filename[MCHAR];

    // initialise static variables
  initialize();

    // test arguments
  if ( argc==1 ) strcpy( data_file, "tn.dat" );
  else if ( argc==2 ) strcpy( data_file, argv[1] );
  else {
    pri( "Usage: tochnog" );
    pri( "or:    tochnog file.dat" );
    pri( "or:    tochnog file.dat > file.out" );
    exit(TN_EXIT_STATUS);
  }

    // append .dat to input file name
  l = strlen( data_file );
  strcpy( data_file_base, "" );
  for ( i=0; i<l && !any_point; i++ ) {
    if ( data_file[i]=='.' ) any_point = 1;
    else strncat( data_file_base, &data_file[i], 1 );
  }
  if ( !any_point ) strcat( data_file, ".dat" );

    // read input file
  input( );

    // delete any old *flavia* files
  if ( ndim==3 ) {
    strcpy( filename, data_file_base );   
    strcat( filename, ".flavia.msh" );
    ofstream out1( filename );
    out1.close();
  }

  if ( ndim==2 ) {
    strcpy( filename, data_file_base );   
    strcat( filename, ".flavia.dat" );
    ofstream out2( filename );
    out2.close();
  }

  strcpy( filename, data_file_base );
  strcat( filename, ".flavia.res" );
  ofstream out3( filename );
  out3.close();

    // delete tecplot.plt
  strcpy( filename, "tecplot.plt" );
  ofstream out4( filename );
  out4.close();

    // delete tn.dvd
  strcpy( filename, "tn.dvd" );
  ofstream out5( filename );
  out5.close();

    // fe analysis
  top();

    // round up things
  exit_tn();

    // and exit
  return 0;
}
