#include <sys/types.h>
#include <sys/socket.h>
#include <stdio.h>
#include <netinet/in.h>
#include <sys/time.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/wait.h> 
#include <signal.h>
#include "configread.h"


// Define this!
extern void server_init(void);
extern void server_process(char* buffer, int process,int* buflen);
extern void server_exit(void);

#define MAX_CONNECTIONS 5

#define SOCKLEN_T unsigned int //socklen_t

int serverbusy=1;


void signal_handler(int signum)
{
    if(signum == SIGCHLD)
    {
        while(waitpid(-1,NULL,WNOHANG) > 0); // clean up child processes
    }
    /*
    else
    {
        while(waitpid(-1,NULL,WNOHANG) > 0);
//        exit(0);
    }
*/
}


int main(int argc, char**argv)
{
    int server_sockfd, client_sockfd;
    SOCKLEN_T server_len, client_len;
    struct sockaddr_in server_address;
    struct sockaddr_in client_address;
    int result;
    int maxConnections=MAX_CONNECTIONS;
    int process=0;
    fd_set readfds, testfds;

    ConfigInit();
    if (argc>1)
    {
        ParseConfigFile(argv[1]);
    }
    else
    {
        ParseConfigFile("yacasserver.ini");
    }

    
    server_sockfd = socket(AF_INET, SOCK_STREAM, 0);
    {
        int rsp;
        if (setsockopt(server_sockfd,SOL_SOCKET,SO_REUSEADDR,(void*)&rsp,sizeof(int)))
        {
            perror("YacasServer Could not set socket options\n");
            exit(1);
        }
    }

    server_address.sin_family = AF_INET;
    server_address.sin_addr.s_addr = htonl(INADDR_ANY);
    server_address.sin_port = htons(9734);
    server_len = sizeof(server_address);

    if (bind(server_sockfd, (struct sockaddr *)&server_address, server_len))
    {
        perror("YacasServer Could not bind to the socket\n");
        exit(1);
    }
    if (listen(server_sockfd, maxConnections))
    {
        perror("YacasServer Could not listen to the socket\n");
        exit(1);
    }

    FD_ZERO(&readfds);
    FD_SET(server_sockfd, &readfds);

    server_init();
    atexit(server_exit);
    
    //LOGTODO    printf("server waiting\n");
    while(serverbusy)
    {
        int fd;
        int nread;
        testfds = readfds;

        result = select(FD_SETSIZE, &testfds, (fd_set *)0, 
                        (fd_set *)0, (struct timeval *) 0);

        if(result < 1)
        {
            perror("server5");
            exit(1);
        }
        for(fd = 0; fd < FD_SETSIZE; fd++)
        {
            while(waitpid(-1,NULL,WNOHANG) > 0); /* clean up child processes */
            if(FD_ISSET(fd,&testfds))
            {
                if(fd == server_sockfd)
                {
                    client_sockfd = accept(server_sockfd, 
                        (struct sockaddr *)&client_address, &client_len);
                    FD_SET(client_sockfd, &readfds);
                    //LOGTODO                    printf("adding client on fd %d\n", client_sockfd);
                }
                else
                {
                    ioctl(fd, FIONREAD, &nread);

                    if(nread == 0)
                    {
                        close(fd);
                        FD_CLR(fd, &readfds);
                        //LOGTODO                        printf("removing client on fd %d\n", fd);
                    }
                    else
                    {
                        process++;

                        if (fork() == 0)
                        {
                            int buflen=0;
                            char buffer[16384];
                            if (nread>16384)
                                nread=16384;
                            read(fd, buffer, nread);
                            buffer[nread]='\0';
                            //LOGTODO                            printf("serving client on fd %d: \n", fd);

                            //LOGTODO                            printf("process %d\n",process);


                            server_process(buffer,process,&buflen);

                            //LOGTODO printf("Server Got %s\n",buffer);

                            if (buflen>0)
                                write(fd, &buffer[0], buflen);

                            close(fd);
                            FD_CLR(fd, &readfds);
                            //LOGTODO                            printf("removing client on fd %d\n", fd);
                            exit(0);
                        }
                        else
                        {
                            close(fd);
                            FD_CLR(fd, &readfds);
                        }
                    }
                }
            }
        }
    }
    exit(0);
}
