
#ifndef __lispcleanupstack_h__
#define __lispcleanupstack_h__

#include "grower.h"

class LispBase
{
public:
    virtual void Delete()=0;
};

class LispCleanup
{
public:
    virtual ~LispCleanup();
    virtual void Push(LispBase& aObject);
    virtual void Pop();
    virtual void Delete();
    void CheckStackEmpty();

protected:
    CArrayGrower<LispBase*> iObjects;
};


class DeletingLispCleanup : public LispCleanup
{
public:
    virtual ~DeletingLispCleanup();
    virtual void Push(LispBase& aObject);
    virtual void Pop();
    virtual void Delete();
};


#endif


