
/** \file lispglobals.h
 *  Storage of globals in a associated hash
 *
 */

#ifndef __lispglobals_h__
#define __lispglobals_h__

#include "lispobject.h"
#include "lisphash.h"



class LispGlobalVariable
{
public:
    inline LispGlobalVariable(const LispGlobalVariable& aOther);
    LispGlobalVariable(LispPtr& aValue): iValue(aValue) {}
    inline LispGlobalVariable& operator=(const LispGlobalVariable& aOther);
    LispPtr iValue;
};

typedef LispAssociatedHash<LispGlobalVariable> LispGlobal;


inline LispGlobalVariable::LispGlobalVariable(const LispGlobalVariable& aOther)
{
    iValue.Set(aOther.iValue.Get());
}

inline LispGlobalVariable& LispGlobalVariable::operator=(const LispGlobalVariable& aOther)
{
    iValue.Set(aOther.iValue.Get());
    return *this;
}


#endif

