
#include "lispassert.h"
#include "lisperror.h"

inline LispShort LispObject::RefCount() const
{
    return iReferenceCount;
}

inline void LispObject::IncreaseRefCount()
{
    LISPASSERT(iReferenceCount<ReferenceMax);
    iReferenceCount = iReferenceCount+1;
}

inline void LispObject::DecreaseRefCount()
{
    LISPASSERT(iReferenceCount>0);
    iReferenceCount = iReferenceCount-1;
    if (!iReferenceCount)
    {
        delete this;
#ifdef LISP_DEBUGHEAP
        DecNrObjects();
#endif
    }
}

inline LispInt LispObject::ReferenceCount() const
{
    return iReferenceCount;
}


inline LispPtr& LispObject::Next()
{
    return iNext;
}

inline LispInt LispObject::operator==(LispObject& aOther)
{
    return Equal(aOther);
}

inline LispInt LispObject::operator!=(LispObject& aOther)
{
    return !Equal(aOther);
}

inline LispObject* LispPtr::Get() const
{
    return iNext;
}

inline LispObject* LispPtr::operator()()
{
    return iNext;
}

inline LispPtr* LispIterator::Ptr()
{
    return iPtr;
}

inline void LispPtr::GoNext()
{
    LISPASSERT(iNext != NULL);
    Set(iNext->Next().Get());
}



inline LispObject* LispIterator::operator()()
{
    return iPtr->Get();
}

inline void LispIterator::GoNext()
{
    Check(iPtr->Get() != NULL,KLispErrListNotLongEnough);
    iPtr = &(iPtr->Get()->Next());
}

inline void LispIterator::GoSub()
{
    Check(iPtr->Get() != NULL,KLispErrInvalidArg);
    Check(iPtr->Get()->SubList() != NULL,KLispErrNotList);
    iPtr = iPtr->Get()->SubList();
}

