
#include <time.h>
#include <stdio.h>

#include "unixcommandline.h"

void CUnixCommandLine::NewLine()
{
    printf("\n");
}

void CUnixCommandLine::Pause()
{
    int i=clock()+CLOCKS_PER_SEC/4;
    while (clock()<i);
}

void CUnixCommandLine::ShowLine(LispCharPtr prompt,LispInt promptlen,LispInt cursor)
{
    printf("\r%c[K",27); //Clear line
    printf("\r%s%s",prompt,&iLine[0]); // display line
    printf("\r");                     // go back
    printf("%c[%dC",27,cursor+promptlen); // position cursor
    fflush(stdout);
}


CUnixCommandLine::CUnixCommandLine()
{
    /* set termio so we can do our own input processing */
    tcgetattr(0, &orig_termio);
    rl_termio = orig_termio;
    rl_termio.c_iflag &= ~(BRKINT|PARMRK|INPCK/*|IUCLC*/|IXON|IXOFF);
    rl_termio.c_iflag |=  (IGNBRK|IGNPAR);
    /* rl_termio.c_oflag &= ~(ONOCR); Costas Sphocleous Irvine,CA */
    rl_termio.c_lflag &= ~(ICANON|ECHO|ECHOE|ECHOK|ECHONL|NOFLSH);
    rl_termio.c_lflag |=  (ISIG);
    rl_termio.c_cc[VMIN] = 1;
    rl_termio.c_cc[VTIME] = 0;
    term_chars[VERASE]   = orig_termio.c_cc[VERASE];
    term_chars[VEOF]     = orig_termio.c_cc[VEOF];
    term_chars[VKILL]    = orig_termio.c_cc[VKILL];
    term_chars[VWERASE]  = orig_termio.c_cc[VWERASE];
    term_chars[VREPRINT] = orig_termio.c_cc[VREPRINT];
    term_chars[VSUSP]    = orig_termio.c_cc[VSUSP];
    /* disable suspending process on ^Z */
    rl_termio.c_cc[VSUSP] = 0;
    tcsetattr(0, TCSADRAIN, &rl_termio);

    FILE*f=fopen("history.log","r");
    if (f)
    {
        if(f)
        {
#define BufSz 256
            char buff[BufSz];
            while(fgets(buff,BufSz-2,f))
            {
                int i;
                for(i=0;buff[i] && buff[i] != '\n';++i)
                    ;
                buff[i++] = '\0';
                LispStringPtr ptr = new LispString(buff);
                iHistory.Append(ptr);
                
            }
            fclose(f);
        }
    }

}
CUnixCommandLine::~CUnixCommandLine()
{
    tcsetattr(0, TCSADRAIN, &orig_termio);

    FILE*f=fopen("history.log","w");
    if (f)
    {
        int i;
        for (i=0;i<iHistory.NrItems();i++)
        {
            fprintf(f,"%s\n",iHistory[i]->String());
        }
        fclose(f);
    }
}

LispInt CUnixCommandLine::GetKey()
{
    LispInt c;
    c=getc(stdin);

    if (c == term_chars[VERASE]) /* Backspace */
    {
        c = eBackSpace;
    }
    else if (c == term_chars[VEOF]) /* delete */
    {
        c = eDelete;
    }
    else
    {
        switch (c)
        {
        case 10:        /* Enter */
            c = eEnter;
            break;
        case 001:		/* ^A  (unix home) */
            c = eHome;
            break;
        case 005:		/* ^E  (unix end) */
            c = eEnd;
            break;
        case 004:		/* ^D  (unix delete) */
        case 127:
            c = eDelete;
            break;
        case  8:              /* ^H  (unix backspace) */
            c = eBackSpace;
            break;
        case 033:
            {
                c = getc(stdin); /* check for CSI */
                if (c == '[')
                {
                    c = getc(stdin); /* get command character */
                    switch (c)
                    {
                    case 'D': /* left arrow key */
                        c = eLeft;
                        break;
                    case 'C': /* right arrow key */
                        c = eRight;
                        break;
                    case 'A': /* up arrow key */
                        c = eUp;
                        break;
                    case 'B': /* down arrow key */
                        c = eDown;
                        break;
                    case 'H': /* home */
                        c = eHome;
                        break;
                    case 'F': /* end */
                        c = eEnd;
                        break;
                    }
                }
            }
            break;
        }
    }
    return c;
}



