
#include "processing.h"


CTexture2d* DepthToColor(CTexture2d& aSource,PlatInt aMinDepth, PlatInt aMaxDepth)
{
    PlatInt i;
    PlatInt nr = aSource.NrItems();

    CTexture2d *result = new CTexture2d(aSource.Width(),aSource.Height());
    if (result == NULL)
        return result;
    LISPASSERT(aMaxDepth > aMinDepth);
    for (i=0;i<nr;i++)
    {
        PlatInt original = aSource[i];
        PlatPixel res;
        original-=aMinDepth;
        if (original < 0)
            original=0;
        original*=255;
        original /= (aMaxDepth-aMinDepth);
        if (original > 255)
            original = 255;

        res = Pixel(original,original,original,original);
        (*result)[i] = res;

    }
    return result;
}

void SobelFilterLines(CTexture2d& aTarget,CTexture2d& aSource)
{
    PlatInt width  = aTarget.Width();
    PlatInt height = aTarget.Height();

    LISPASSERT(width == aSource.Width());
    LISPASSERT(height == aSource.Height());

    PlatInt x,y;
    for (y=1;y<height-1;y++)
        for (x=1;x<width-1;x++)
        {
            PlatInt suma=0;
            PlatInt sumb=0;

            suma =
                1L*aSource.GetPixel(x-1,y-1) +
                2L*aSource.GetPixel(x  ,y-1) +
                1L*aSource.GetPixel(x+1,y-1) +

                -1L*aSource.GetPixel(x-1,y+1) +
                -2L*aSource.GetPixel(x  ,y+1) +
                -1L*aSource.GetPixel(x+1,y+1);

            sumb =
                -1L*aSource.GetPixel(x-1,y-1) +
                -2L*aSource.GetPixel(x-1,y  ) +
                -1L*aSource.GetPixel(x-1,y+1) +

                1L*aSource.GetPixel(x+1,y-1) +
                2L*aSource.GetPixel(x+1,y  ) +
                1L*aSource.GetPixel(x+1,y+1);

            if (suma<0) suma=-suma;
            if (sumb<0) sumb=-sumb;
            if (suma+sumb > 8)
            {
                aTarget.GetPixel(x,y) = 0;
            }
        }
}


CTexture2d* CombinePixels(CTexture2d& aSource,PlatInt aBits)
{
    PlatInt step=1L<<(aBits);
    PlatInt width  = aSource.Width()>>(aBits);
    PlatInt height = aSource.Height()>>(aBits);
    CTexture2d *result = new CTexture2d(width,height);
    PlatInt x,y;
    for (y=0;y<height;y++)
        for (x=0;x<width;x++)
        {
            PlatInt ix,iy;
            PlatInt redaccu=0;
            PlatInt greenaccu=0;
            PlatInt blueaccu=0;
            PlatInt alphaaccu=0;
            for (ix=0;ix<step;ix++)
                for (iy=0;iy<step;iy++)
                {
                     PlatPixel pixel = aSource.GetPixel((x<<(aBits))+ix,(y<<(aBits))+iy);
                    redaccu  +=Red  (pixel);
                    greenaccu+=Green(pixel);
                    blueaccu +=Blue (pixel);
                    alphaaccu+=Alpha(pixel);
                }
            redaccu /= (step*step);
            greenaccu /= (step*step);
            blueaccu /= (step*step);
            alphaaccu /= (step*step);
            (*result).GetPixel(x,y) =
                Pixel(redaccu,greenaccu,blueaccu,alphaaccu);
        }
    return result;
}
