
#include <stdio.h>
#include "triage.h"
#include "render.h"
#include "hershey.h"
#include "targagrabber.h"
#include "lisp.h"
#include "line2d.h"

/*
 TODO:
 - make some nice examples.
 - fonts: allow selection
 - let the font drawing use the native triage transforms.
 */

/*
 glCanvas width height
 glClearColor r g b a
 glClearDepthMax
 glClearDepthMin
 glLine x0 y0 z0 w0 r0 g0 b0 a0 x1 y1 z1 w1 r1 g1 b1 a1
 glTriangle x0 y0 z0 w0 r0 g0 b0 a0 x1 y1 z1 w1 r1 g1 b1 a1 x2 y2 z2 w2 r2 g2 b2 a2
 glPushMatrix
 glPopMatrix
 glRotateX angle
 glRotateY angle
 glRotateZ angle
 glTranslate x y z
 glScale x y z
 glFont fontname
 glText x y width height string
 glSaveTarga filename
 glExit

 */

CTexture2d *texture = NULL;
CTexture2d *depth   = NULL;
CTriage    *triage  = NULL;
CHersheyFont *font  = NULL;

int busy=1;


void ReadVector(CVector& v,int offset)
{
    v.xf[0] = get_float(get_arg(offset+0));
    v.xf[1] = get_float(get_arg(offset+1));
    v.xf[2] = get_float(get_arg(offset+2));
    v.xf[3] = get_float(get_arg(offset+3));
}

void ReadColor(PlatPixel& c0,int offset)
{
    int red, green,blue,alpha;
    red   = get_int(get_arg(offset+0));
    green = get_int(get_arg(offset+1));
    blue  = get_int(get_arg(offset+2));
    alpha = get_int(get_arg(offset+3));
    c0 = Pixel(red, green,blue,alpha);
}

#define ENTER push(arglist); arglist = eval_args(p->tail)
#define LEAVE arglist = pop(); return nil

NODE* def_glCanvas(NODE*p)
{
    int width,height;
    ENTER;
    width  = get_int(get_arg(0));
    height = get_int(get_arg(1));
    texture = new CTexture2d(width,height);
    depth = new CTexture2d(width,height);
    triage = new CTriage(*texture,*depth);
    LEAVE;
}

NODE* def_glLine(NODE*p)
{
    CVector vv0;
    CVector vv1;
    PlatPixel c0,c1;

    ENTER;
    ReadVector(vv0,0);
    ReadColor(c0,4);
    ReadVector(vv1,8);
    ReadColor(c1,12);
    triage->Line(vv0, c0, vv1, c1);
    LEAVE;
}

NODE* def_glSaveTarga(NODE*p)
{
    ENTER;
    SaveAsTarga(get_arg(0)->s,&(*texture)[0],
                texture->Width(), texture->Height());
    LEAVE;
}

NODE* def_glClearColor(NODE*p)
{
    PlatPixel c;
    ENTER;
    ReadColor(c,0);
    Clear(*texture, c);
    LEAVE;
}

NODE* def_glClearDepthMax(NODE*p)
{
    Clear(*depth, PlatMaxDepth);
}
NODE* def_glClearDepthMin(NODE*p)
{
    Clear(*depth, 0);
}

NODE* def_glPushMatrix(NODE*p)
{
    triage->Transform().PushMatrix();
}

NODE* def_glPopMatrix(NODE*p)
{
    triage->Transform().PopMatrix();
}

NODE* def_glTriangle(NODE*p)
{
    CVector v0,v1,v2;
    PlatPixel c0,c1,c2;
    ENTER;
    ReadVector(v0,0);
    ReadColor(c0,4);
    ReadVector(v1,8);
    ReadColor(c1,12);
    ReadVector(v2,16);
    ReadColor(c2,20);
    triage->Triangle(v0,c0, v1,c1, v2,c2);
    LEAVE;
}

NODE* def_glRotateZ(NODE*p)
{
    double angle;
    ENTER;
    angle = get_float(get_arg(0));
    triage->RotateZ(angle);
    LEAVE;
}
NODE* def_glRotateY(NODE*p)
{
    double angle;
    ENTER;
    angle = get_float(get_arg(0));
    triage->RotateY(angle);
    LEAVE;
}
NODE* def_glRotateX(NODE*p)
{
    double angle;
    ENTER;
    angle = get_float(get_arg(0));
    triage->RotateX(angle);
    LEAVE;
}

NODE* def_glTranslate(NODE*p)
{
    double x,y,z;
    ENTER;
    x = get_float(get_arg(0));
    y = get_float(get_arg(1));
    z = get_float(get_arg(2));
    triage->Translate(x,y,z);
    LEAVE;
}
NODE* def_glScale(NODE*p)
{
    double x,y,z;
    ENTER;
    x = get_float(get_arg(0));
    y = get_float(get_arg(1));
    z = get_float(get_arg(2));
    CMatrix m;
    IdentityMatrix(m);
    Scale(m, x,y,z);
    triage->Transform().Apply(m);
    LEAVE;
}

NODE* def_glFont(NODE*p)
{
    if (font)
        delete font;
    font = new CHersheyFont(astrology);
}




NODE* def_glText(NODE*p)
{
    int x,y;
    float width,height;
    ENTER;
    x = get_int(get_arg(0));
    y = get_int(get_arg(1));
    width  = get_float(get_arg(2));
    height = get_float(get_arg(3));

    font->setWidth(width);
    font->setHeight(height);
    CTriageGraphics gr(*triage);
    font->drawString (get_arg(4)->s,x,y,gr);
    LEAVE;
}


int main(int argc, char** argv)
{
    init();

    lookup("glCanvas")->f = def_glCanvas;
    lookup("glLine")->f = def_glLine;
    lookup("glSaveTarga")->f = def_glSaveTarga;
    lookup("glClearColor")->f = def_glClearColor;
    lookup("glClearDepthMax")->f = def_glClearDepthMax;
    lookup("glClearDepthMin")->f = def_glClearDepthMin;
    lookup("glPushMatrix")->f = def_glPushMatrix;
    lookup("glPopMatrix")->f = def_glPopMatrix;
    lookup("glTriangle")->f = def_glTriangle;
    lookup("glRotateZ")->f = def_glRotateZ;
    lookup("glRotateY")->f = def_glRotateY;
    lookup("glRotateX")->f = def_glRotateX;
    lookup("glTranslate")->f = def_glTranslate;
    lookup("glScale")->f = def_glScale;
    lookup("glFont")->f = def_glFont;
    lookup("glText")->f = def_glText;

    if (argc>1)
    {
        int i;
        for (i = 1; i < argc; i++)
            load(argv[i]);
        cleanup();
        return 0;
    }

    init_io();
    while (!Quit())
        read_eval_print();
    cleanup();

    if (texture) delete texture;
    if (depth)   delete depth;
    if (triage)  delete triage;
    if (font)    delete font;

    return 0;
}
