#ifndef __autil_clone_ptr__
#define __autil_clone_ptr__

// The copy constructor calls clone to create a new copy

// The assignment operator calls the copy method of the current ptr 
// unless it is null.  If null it will clone the other object.

namespace autil {

  template <typename Class> 
  class ClonePtr {
  public:
    Class * ptr;

    ClonePtr() : ptr(0) {}
    explicit ClonePtr(Class * p) : ptr(p) {}
    
    ClonePtr(const ClonePtr & other);
    ClonePtr & operator= (Class * p);
    ClonePtr & operator= (const ClonePtr & other) {
      assign(other.ptr); 
      return *this;
    }
    
    void assign(const Class * p);

    operator Class * () const {return ptr;}
    Class & operator *  ()const  {return *ptr;}
    Class * operator-> () const {return ptr;}
    operator bool () const {return ptr;}

    void del();
    
    ~ClonePtr();
  };

}

#endif

