
#include "leditdist.hh"
#include "editdist.hh"

#include <cassert>

namespace autil {
  inline int edit_distance(const char * a, const char * b, 
			   int level, // starting level
			   int limit, // maximum level
			   const EditDistanceWeights & w 
			   = EditDistanceWeights()) 
  {
    int score;
    assert(level > 0  && limit >= level);
    do {
      if (level == 2) {
	score = limit2_edit_distance(a,b,w);
      } else if (level < 6) {
	score = limit_edit_distance(a,b,level,w);
      } else {
	score = edit_distance(a,b,w);
      }
      ++level;
    } while (score >= LARGE_NUM && level <= limit);
    return score;
  }
}
