// hash_string
// Copyright 1998 by Kevin Atkinson under the terms of the LGPL

#ifndef __autil_hash_string_hh__
#define __autil_hash_string_hh__

namespace autil {

  template<class String>
  struct HashString {
    typedef size_t         result_type;
    typedef const String & argument_type;
    
    inline size_t operator() (const String &str) const {
      size_t h = 0;
      for (typename String::const_iterator s = str.begin(); 
	   s != str.end(); 
	   ++s)
	h=5*h + *s;
      return h;
    }
  };
  
  template<>
  struct HashString<const char *> {
    typedef size_t       result_type;
    typedef const char * argument_type;
    
    inline size_t operator() (const char * s) const {
      size_t h = 0;
      for (; *s; ++s)
	h=5*h + *s;
      return h;
    }
  };

}

#endif
