#!/usr/bin/python 
#
#  SpecFile.py - Wrapper for RPM .spec file.
#
#  $Id: SpecFile.py,v 1.1 1998/08/24 21:41:48 cg Exp $
#
#  SGMLtools - an SGML toolkit.
#  Copyright (C) 1998 Cees de Groot
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

from string import *

#
#  A wrapper around an RPM .spec file. When a SpecFile is instantiated,
#  the indicated .spec is loaded and made accessible. This code was
#  "heavily inspired" by Ken MacLeod's PkgMaker Perl module :-)
#
class SpecFile:
    #
    #  Storage for the various components.
    #
    __fields = {}
    __sections = {}
    
    def __init__(self, filename):
	"""
	    Create a SpecFile object and fill it with data by parsing
	    the indicated .spec file.
	"""

	#
	#  Slurp the file and parse it.
	#
	fh = open(filename, "r")
	inPreamble = 1
	currentSection = ''
	for line in fh.readlines():
	    line = line[0:-1]
	    strip(line)
	    if len(line) == 0 or line[0] == '#':
		continue

	    if line[0] == '%':
		#
		#  New section, iff we know it as such.
		#
		inPreamble = 0
		newSection = lower(line[1:])
		sep = find(newSection, ' ')
		if sep > -1:
		    newSection = newSection[0:sep]
		if SpecFile.__dict__.has_key('get' + capitalize(newSection)):
		    currentSection = newSection
		    continue

	    if inPreamble:
		#
		#  Preamble line - split and store.
		#
		(key, value) = split(line, ':', 1)
		key = lower(strip(key))
		value = strip(value)
		if not self.__fields.has_key(key):
		    self.__fields[key] = []
		self.__fields[key].append(value)
		continue

	    #
	    #  Default: body of current section
	    #
	    if not self.__sections.has_key(currentSection):
		self.__sections[currentSection] = []
	    self.__sections[currentSection].append(line)

	fh.close()

    def dump(self):
	"""
	    Dump this object to stdout. Neat for debugging.
	"""
	print self.__fields
	print self.__sections
    
    def getPreamble(self, key):
	"""
	    Get the specified key from the preamble. Returns a list
	    containing one or more elements that were defined under
	    key in the preamble or None.
	"""
	if self.__fields.has_key(key):
	    return self.__fields[key]
	else:
	    return None

    def getSection(self, section):
	"""
	    Get the specified section. Note that this will return the
	    raw list of lines found within the section, whereas the
	    specialized functions get<Xxx> may cook the list before
	    returning it.
	"""
	if self.__sections.has_key(section):
	    return self.__sections[section]
	else:
	    return None


    #
    #  get.... methods for the sections. Split up so that some
    #  post-processing may be done. This list of functions is 
    #  also used by the parser in order to determine what 
    #  %<keyword> sections to recognize: those that have a
    #  get<Keyword> method.
    #
    #  A lot of cooking up needs to be added here...
    #
    def getPackage(self):
	return self.getSection('package')

    def getPrep(self):
	return self.getSection('prep')

    def getBuild(self):
	return self.getSection('build')

    def getInstall(self):
	return self.getSection('install')

    def getClean(self):
	return self.getSection('clean')

    def getPreun(self):
	return self.getSection('preun')

    def getPostun(self):
	return self.getSection('postun')

    def getPre(self):
	return self.getSection('pre')

    def getPost(self):
	return self.getSection('post')

    def getFiles(self):
	return self.getSection('files')

    def getChangelog(self):
	return self.getSection('changelog')

    def getDescription(self):
	return self.getSection('description')

    def getTriggerun(self):
	return self.getSection('triggerun')

    def getTrigger(self):
	return self.getSection('trigger')

    def getVerifyscript(self):
	return self.getSection('verifyscript')
    
#
#  Test code
#
if __name__ == '__main__':
    result = SpecFile("../../packages/SPECS/sgmltools-1.1.spec")
    result.dump()
