#!/usr/bin/python
#
#  readpackagelist.py - Read the packagelist file.
#
#  $Id: readpackagelist.py,v 1.1 1998/08/24 21:41:55 cg Exp $
#
#  SGMLtools - an SGML toolkit.
#  Copyright (C) 1998 Cees A. de Groot
#  Copyright (c) 1998 Evelyn Mitchell (python port)
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#

"""
NAME

    readpackagelist.pl - Read the packagelist file.

SYNOPSIS

    pkginfo = readpackagelist(filename)

DESCRIPTION

    The subroutine readpackagelist reads a package list file. This
    is a simple file containing information on CVS tags, versions, and
    RPM build numbers and is used by other Perl modules to build and
    distribute SGMLtools components. It returns a hash with
    the package names as keys and hashes containing (prefix, version,
    build, flags) as data.

    In the returned hash, a KEYS element references an array containing the 
    packages as they were encountered in the package list file. This can be
    used to traverse the package list in the original order.

"""

import re
import string

def readpackagelist(file):
    # returns a dictionary
    retval = {}
    array = []
    retval['KEYS'] = array

    try:
	infile = open(file, "r")
    except Exception, e:
	print "Open %s failed for %s" % (file, e)
    
    for line in infile.readlines():
	if line[0] == '#':
	    continue	# skip comment

	#
	#  strip trailing newlines, string.rstrip() could be used, but
	#  would also remove any trailing spaces (which might be bad?)
	#
	while line[-1] == '\r' or line[-1] == '\n': line = line[:-1]

	string.strip(line)    # remove leading and trailing whitespace

	# split into 5 fields on whitespace
	try:
	    (prefix, name, vers, build, flags) = string.split(line, ' ', 5)
	except:
	    # no flags
	    try: 
		(prefix, name, vers, build) = string.split(line, ' ', 4)
		flags = ""
	    except:
		# not enough fields
		print "Error line %s in file %s has too few fields" % (line, file) 
	flaghash = {}
	if flags:
	    try:
		#
		# do we have a flag?
		# flags might be
		#    noinstall - ignore package
		#  noimport -
		#  dep=pkg[+pkg...] - dependencies
		#
		string.strip(flags)    # remove leading and trailing whitespace
		curflag = string.split(flags, ',', 1)
		try:
		    (key, val) = string.split(curflag, '=', 2) 
		except:
		    # didn't find key = value
		    # noinstall or noimport
		    key = curflag 
		    val = "true"    
		# create a hash
		flaghash[key[0]] = val
	    except:
		pass
	retval[name] = {'prefix': prefix, 'version': vers, 
	    'build': build, 'flags': flaghash}

	array.append(name)

    return retval

#
#  Testcode
#
if __name__ == '__main__':
    test = readpackagelist("../packages/packagelist")
    pat = re.compile ('\.')
    for i in test["KEYS"]:
	p = test[i]['prefix']
	v = test[i]['version']
	b = test[i]['build']
	tag = p + "." + v
	tag = pat.sub( '_', tag)
	print "%s -> %s, %s, %s (%s)" %(i, b, p, v, tag)
	try:
	    flaghash = test[i]['flags']
	    #print " %s = %s" % ( i, test[i]['flags'][i] )
	    keys = flaghash.keys()
	    for key in keys:
		print " %s = %s" % ( key, flaghash[key] )
	except:
	    pass

