/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1996-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

  #include <vslib.h>
  #include <ctype.h>
  #include <errno.h>

  #ifndef _SEE_EXE_
  // suppose see is used as part of VFU
  #include "vfuopt.h"
  #include "vfu.h"
  #endif

  #include "grep.h"

  #define MAXX ConMaxX()
  #define MAXY ConMaxY()
  #define ROWS  (MAXY-1)

  #ifndef MAX_PATH
  #define MAX_PATH 512
  #endif

  #define BSIZE       512 // 4096
  #define TABSIZE     8

  int SeeSLColor  = 112; // status line color
  int SeeWRNColor =  79; // warning color

  static char buff[BSIZE+32]; // actually we need just 8 'cos the TAB expansion
                              // can overflow only 8 but JTBS...
  long WRAP = BSIZE;
  int  FI = 0; // file index
  int  FC = 0; // files count

  struct TSeeFile
    {
      long pos;
      char fn[MAX_PATH]; // filename
      int temp; // if `1' file is temporary -- should be deleted!
      FILE* f;
      long fs; // file size
      long line;
      long lastl; // last line
      long endr;
    };

  #define MSF   10 // max see files
  TSeeFile SFiles[MSF];

  #define SFPOS   SFiles[FI].pos
  #define SFF     SFiles[FI].f
  #define SFFN    SFiles[FI].fn
  #define SFFS    SFiles[FI].fs
  #define SFLINE  SFiles[FI].line
  #define SFLASTL SFiles[FI].lastl
  #define SFENDR  SFiles[FI].endr

  long column = 0;
  int  GridColor[] = { cNORMAL, cCYAN, 113 };

  PSZCluster SeeFilters;

  char _sss[4096];

  int  nocase = 0;

  struct TSeeOptions
  {
    char SeeLastFindStr[128];
    int  HEX;
    int  GRID;
    int  decpos;
    int  showeol;
  };
  TSeeOptions seeopt;

  #define CHKPOS { if ( SFPOS > SFFS ) SFPOS = SFFS; if ( SFPOS < 0 ) SFPOS = 0; }

  int XLAT = 0;
  char* XLATstr[] = { "none", " BGD xlat ", " BGW xlat " };
  int HandleBS  = 1; // handle backspaces
  int HandleTAB = 1; // handle TABs

  char HEXCHARS[] = "0123456789ABCDEF";

  char BGxlat[2][64] =
  {
  "",
  "abwgdevzijklmnoprstufhc`[]yxuqABWGDEVZIJKLMNOPRSTUFHC`[]YXUQ"
  };

  char BGWxlat[2][64] =
  {
  "",
  "abwgdevzijklmnoprstufhc`[]yxuqABWGDEVZIJKLMNOPRSTUFHC`[]YXUQ"
  };

  //////////////////////////////////////////////////////////////////////////
  void SeeFilter( char *s, int size )
  {
    int z;
    for ( z = 0; z < size; z++ ) if ( (unsigned char)s[z] < 32 ) s[z] = '.';
    if (XLAT == 1) StrTR( s,  BGxlat[0],  BGxlat[1] ); else
    if (XLAT == 2) StrTR( s, BGWxlat[0], BGWxlat[1] );
  };

  //////////////////////////////////////////////////////////////////////////
  void SeeMsg( const char* s, int slcolor = SeeSLColor )
  {
    ConOut( 1, MAXY, s, slcolor ); ConCE( slcolor );
  };

  //////////////////////////////////////////////////////////////////////////
  int SeeDrawHex()
  {
    int z = 0;
    int i = 0;
    char lin[128];
    char str[64];
    int buffsize = ROWS*16; // all size :)
    fseek( SFF, SFPOS, SEEK_SET );
    buffsize = fread( buff, 1, buffsize, SFF );
    for( z = 0; z < ROWS; z++ )
      {
      sprintf( lin, seeopt.decpos?"%8d : ":"%08X : ", SFPOS+z*16 );
      for ( i = 0; i < 16; i++ )
        {
        if ( z*16+i < buffsize )
          {
          sprintf( lin+11+i*3+(i>7)*2, (i==7)?"%02X - ":"%02X ", (unsigned char)buff[z*16+i]);
          str[i] = buff[z*16+i];
          }
        else
          {
          sprintf( lin+11+i*3+(i>7)*2, (i==7)?"     ":"   " );
          str[i] = ' ';
          }
        }
      str[16] = 0;
      SeeFilter( str, 16 );
      if ((z-1)*16+i < buffsize)
        strcat( lin, ": " );
      else
        strcat( lin, "  " );
      if (lin[11] == ' ') lin[11] = '~'; // hack
      strcat( lin, str );
      ConOut( 1, z+1, lin, ((SFPOS/16+z)%2==0)?GridColor[seeopt.GRID]:cNORMAL ); ConCE( cNORMAL );
      }
    sprintf( buff, "| SEE v2.0 | Slot:%2d/%2d |%3d%% | Pos.:%8d of%8d |      | `H' for help ", FI+1, FC, (100*SFPOS)/SFFS, SFPOS, SFFS );
    ConOut( 1, MAXY, buff, SeeSLColor ); ConCE( SeeSLColor );
    return 0;
  }

  //////////////////////////////////////////////////////////////////////////
  // read ahead with tab and backspace expansion
  // result goes into `buff', the margin is `WRAP'
  int ReadText( long &cpos ) // pos is current file position
  {
    buff[0] = 0;
    int z = 0;
    unsigned char ch;
    while( z < WRAP )
      {
      if ( cpos >= SFFS ) break;
      ch = fgetc( SFF );
      cpos++;
      if (HandleBS && ch == 8)
        {
        if (z > 0) z--;
        continue;
        }
      if (HandleTAB && ch == 9)
        {
        int i = ((z/TABSIZE)+1) * TABSIZE - z;
        while( z < WRAP && i > 0 )
          {
          buff[z] = ' ';
          z++;
          i--;
          }
        continue;
        }
      buff[z] = ch;
      z++;
      if ( ch == '\n' ) break;
      }
    return z;
  }

  //////////////////////////////////////////////////////////////////////////
  int SeeDrawText()
  {
    CHKPOS;
    if ( SFLINE == -1 ) SFLASTL = -1;
    long cpos = SFPOS;
    int z = 0;
    int y = 0;
    fseek( SFF, cpos, SEEK_SET );
    while( y < ROWS )
      {
      if ( cpos >= SFFS )
        {
        while( y < ROWS )
          {
          ConOut(1,y+1,"~",cNORMAL); ConCE(cNORMAL);
          y++;
          }
        break;
        }

      z = ReadText( cpos );
      while ( z > 0 && buff[z-1] == '\r' || buff[z-1] == '\n' ) z--;
      buff[z] = 0;
      SeeFilter( buff, z );
// !!! vvv
      int show_lmark = 0;
      int show_rmark = 0;
      int show_eol   = -1;
      if (column)
        {
        if (column >= z)
          {
          buff[0] = 0;
          show_lmark = 1;
          z = 0;
          }
        else
          {
          strcpy( buff, buff + column );
          z -= column;
          }
        }
      if ( z > MAXX )
        {
        buff[MAXX] = 0;
        show_rmark = 1;
        }
      else
        {
        StrPad( buff, -MAXX );
        if ( seeopt.showeol && !show_lmark ) show_eol = z+1;
        }
      ConOut(1,y+1,buff,cNORMAL);
      if (show_lmark) ConOut(1,y+1,"<",chRED);
      if (show_rmark) ConOut( MAXX, y+1, ">", chRED );
      if (show_eol != -1) ConOut( show_eol, y+1, "$", chGREEN );
      y++;
      }
    sprintf( buff, "| SEE v2.0 | Slot:%2d/%2d |%3d%% | Line:%8d of%8d%c|%4d+ | `H' for help ", FI+1, FC, (100*SFPOS)/SFFS, SFLINE, SFLASTL, SFENDR?'*':' ', column+1, SFPOS, SFFS );
    ConOut( 1, MAXY, buff, SeeSLColor ); ConCE( SeeSLColor );
    return 0;
  }

  //////////////////////////////////////////////////////////////////////////
  void SeeDraw()
  {
    seeopt.HEX ? SeeDrawHex() : SeeDrawText();
    if (XLAT) ConOut( MAXX-10, 1, XLATstr[XLAT], SeeSLColor );
  }

  //////////////////////////////////////////////////////////////////////////
  int SeeUp()
  {
    if (seeopt.HEX)
      {
      SFPOS -= 16;
      CHKPOS;
      return 0;
      }
    CHKPOS;
    long cpos = SFPOS;
    if ( cpos == 0 ) return 0;

    long i = WRAP;
    if ( cpos - i < 0 ) i = cpos;
    cpos -= i;
    fseek( SFF, cpos, SEEK_SET );
    long res = fread( buff, 1, i, SFF );
    ASSERT( res == i );
    int z = 0;
    if ( buff[i-1] == '\n' )
      {
      i--;
      z++;
      }
    while( i > 0 && buff[i-1] != '\n' )
      {
      i--;
      z++;
      }
    SFPOS -= z;
    if (SFLINE != -1) SFLINE--;
    return 0;
  }

  //////////////////////////////////////////////////////////////////////////
  int SeeDown()
  {
    if (seeopt.HEX)
      {
      SFPOS += 16;
      CHKPOS;
      return 0;
      }
    int z = 0;
    if ( SFPOS == SFFS ) return 0;
    if (fseek( SFF, SFPOS, SEEK_SET )) return 1;
    int res = fread( buff, 1, WRAP, SFF );
    z = 0;
    while( z < res && buff[z] != '\n' ) z++;
    if (buff[z] == '\n') z++;
    buff[z] = 0;           // need by SeeFindNext()
//    strcpy( cline, buff ); // need by SeeFindNext()
    SFPOS += z;
    if (SFLINE != -1) SFLINE++;
    if ( SFLINE > SFLASTL ) SFLASTL = SFLINE;
    if ( SFPOS >= SFFS ) SFENDR = 1;
    return 0;
  }

  //////////////////////////////////////////////////////////////////////////
  int SeeHome()
  {
    SFPOS = 0;
    SFLINE = 1;
    return 0;
  }

  //////////////////////////////////////////////////////////////////////////
  int SeeEnd2()
  {
    int z = 0;
    if (!SFENDR)
      SFLINE = -1;
    else
      SFLINE = SFLASTL;
    SFPOS = SFFS;
    for ( z = 0; z < ROWS / 2; z++ ) SeeUp();
//    if ( SFPOS < opos ) SFPOS = opos;
    return 0;
  }

  //////////////////////////////////////////////////////////////////////////
  int SeeEnd()
  {
    if (SFENDR)
      {
      return SeeEnd2();
      }
    int z = 0;
    while ( SFPOS < SFFS )
      {
      if ( ConKbHit() && ConGetch() == 27 ) return 1;
      SeeDown();
      if (SFLINE % 1000 == 0)
        {
        char tmp[128];
        sprintf(tmp, " Going down.... line: %6d -- %3d%% (press ESCAPE to cancel) ", SFLINE, long((100.0*SFPOS)/SFFS) );
        SeeMsg(tmp);
        }
      }
    SFENDR = 1;
    for ( z = 0; z < ROWS / 2; z++ ) SeeUp();
    return 0;
  }

  //////////////////////////////////////////////////////////////////////////
  void SeeSwitchHEX()
  {
    seeopt.HEX = !seeopt.HEX;
    if (!seeopt.HEX && SFPOS > 0)
      {
      SeeUp();
      SeeDown();
      }
    SeeDraw();
  }

  //////////////////////////////////////////////////////////////////////////
  int GoTo()
  {
    if(seeopt.HEX)
      {
      sprintf( _sss, "x%X", SFPOS);
      SeeMsg( " Goto pos.: " );
      if (!TextInput( 13, MAXY, "", 20, 20, _sss ))
        {
        SeeDraw();
        return 1;
        }
      long newpos = SFPOS;
      StrCutSpc( _sss );
      StrUpCase( _sss );
      if ( _sss[0] == '-' )
        newpos -= (_sss[1] == 'X')? htol( _sss+2 ): atol( _sss+1 );
      else
      if ( _sss[0] == '+' )
        newpos += (_sss[1] == 'X')? htol( _sss+2 ): atol( _sss+1 );
      else
        newpos  = (_sss[0] == 'X')? htol( _sss+1 ): atol( _sss );
      if (newpos < SFFS) SFPOS = newpos;
      SeeDraw();
      }
    else
      {
      sprintf( _sss, "%d", SFLINE);
      SeeMsg( " Goto line: " );
      if (!TextInput( 13, MAXY, "", 20, 20, _sss ))
        {
        SeeDraw();
        return 1;
        }
      long new_line = SFLINE;
      StrCutSpc( _sss );
      StrUpCase( _sss );
      if ( _sss[0] == '-' )
        new_line -= atol( _sss+1 );
      else
      if ( _sss[0] == '+' )
        new_line += atol( _sss+1 );
      else
        new_line  = atol( _sss );
      if (new_line < 0) new_line = 0;
      if (SFLASTL != -1 && SFENDR && new_line > SFLASTL) new_line = SFLASTL;
      if (new_line == SFLINE)
        {
        SeeDraw();
        return 1;
        }
      if (new_line > SFLINE)
        while( new_line != SFLINE && SFPOS < SFFS )
          {
          if ( ConKbHit() && ConGetch() == 27 ) return 1;
          SeeDown();
          if (SFLINE % 1000 == 0)
            {
            sprintf(_sss, " Going down.... line: %6d -- %3d%% (press ESCAPE to cancel) ", SFLINE, long((100.0*SFPOS)/SFFS) );
            SeeMsg(_sss);
            }
          }
      else
        while( new_line != SFLINE && SFPOS >  0 )
          {
          if ( ConKbHit() && ConGetch() == 27 ) return 1;
          SeeUp();
          if (SFLINE % 1000 == 0)
            {
            sprintf(_sss, " Going up.... line: %6d -- %3d%% (press ESCAPE to cancel) ", SFLINE, long((100.0*SFPOS)/SFFS) );
            SeeMsg(_sss);
            }
          }
      SeeDraw();
      }
    return 0;
  }

  //////////////////////////////////////////////////////////////////////////
  int SeeAddFile( const char* fname )
  {
    if ( FC == MSF ) return 1;
    SFiles[FC].temp = 0;
    strcpy(SFiles[FC].fn, fname);
    FC++;
    return 0;
  }

  //////////////////////////////////////////////////////////////////////////
  int SeeSetFile( int n )
  {
    if ( n >= MSF ) return 1;
    if ( SFiles[n].fn[0] == 0 )
      {
      sprintf( _sss, " Slot %d: <<empty>> ", n+1 );
      SeeMsg( _sss );
      return 1;
      }
    if ( !SFiles[n].f )
      {
      // see filters here
      // NOTE: this is not proper place but it should work fine
      // if temporary file name has'n see reconizable extension
      // which is not happen probably
      // FIXME: rewrite see file add/open/close points
      int sfcount = SeeFilters.count();
      if ( sfcount && SFiles[n].temp == 0 )
        {
        String str;
        char temp[256];
        int z;
        for ( z = 0; z < sfcount; z++ )
          {
          str = SeeFilters[z];
          StrGetFirstWord( str, ",", temp );
          if ( FNMATCH( temp, SFiles[n].fn ) == 0 )
            break;
          str = "";
          }
        if ( str != "" )
          {
          StrReplace( str, "%f", SFiles[n].fn );
          SFiles[n].fn[0] = 0;
          tmpnam( SFiles[n].fn );
          str += " > ";
          str += SFiles[n].fn;
          SFiles[n].temp = 1;
          ConSuspend(); // not required really but just to be safe
          system( str );
          ConRestore(); // JTBS
          ConCHide(); // ?
          };
        }
      // filters end here
      
      SFiles[n].fs = fsize( SFiles[n].fn );
      if (SFiles[n].fs == 0)
        {
        sprintf( _sss, " Zero size file: %s ", SFiles[n].fn );
        SeeMsg( _sss );
        return 2;
        }
      SFiles[n].f = fopen( SFiles[n].fn, "rb" );
      if (!SFiles[n].f)
        {
        sprintf( _sss, " Cannot open file for reading: %s ", SFiles[n].fn );
        SeeMsg( _sss );
        return 2;
        }
      FI = n;
      SFPOS = 0;
      SFLINE = 1;
      SFLASTL = -1;
      SFENDR = 0;
      }
    else
      {
      FI = n;
      }
    // now try to find if it's binary or not
    HandleBS = 1;
    HandleTAB = 1;
    int z = fread( buff, 1, BSIZE, SFF ) - 1;
    while(z > 0)
      {
      if (buff[z] == 0)
        { // accept it as binary -- sorry :)
        HandleBS = 0;
        HandleTAB = 0;
        }
      z--;
      }
    // binary check end
    SeeDraw();
    sprintf( _sss, " Slot %d: %s ", FI+1, SFFN );
    SeeMsg( _sss );
    return 0;
  }

  //////////////////////////////////////////////////////////////////////////
  int SeeCloseAll()
  {
    for ( int z = 0; z < MSF; z++ )
      {
      if (SFiles[z].f) fclose(SFiles[z].f);
      SFiles[z].f = NULL;
      if (SFiles[z].temp) unlink(SFiles[z].fn);
      SFiles[z].fn[0] = 0;
      SFiles[z].temp = 0;
      }
    FC = 0;
    return 0;
  }

  //////////////////////////////////////////////////////////////////////////
  int SeeFindNext()
  {
    if (seeopt.SeeLastFindStr[0] == 0)
      {
      SeeMsg( "No search pattern..." );
      return 1;
      }
    sprintf(_sss, "Searching for `%s'...", seeopt.SeeLastFindStr+1);
    SeeMsg(_sss);
    if (seeopt.HEX)
      SFPOS++;
    else
      SeeDown(); // start search from the next line -- avoid blocking
    long newpos = FSearchStr( seeopt.SeeLastFindStr, SFF, nocase, SFPOS );
    if ( newpos >= 0 )
      {
      SFPOS = newpos;
      if (!seeopt.HEX)
        {
        SeeUp(); // back to the start of the line
        SFLINE += FGrepLines;
        int mpos = newpos - SFPOS; // marker pos
        if ( mpos > MAXX ) column = ( mpos / 8 - 1 )*8;
        mpos -= column;
        SeeDraw();
        if (mpos > 0)
          ConOut( mpos, 1, ">", chMAGENTA );
        }
      else
        SeeDraw();
      sprintf( _sss, "Pattern `%s' found at pos: %d (hex=%X)", seeopt.SeeLastFindStr+1, newpos, newpos );
      SeeMsg( _sss );
      }
    else
      {
      sprintf( _sss, "Pattern `%s' not found...", seeopt.SeeLastFindStr+1 );
      SeeMsg( _sss );
      }
    return 0;
  }

  //////////////////////////////////////////////////////////////////////////
  int SeeFind( char fch, int _nocase ) // `fch' stands for `first char'
  {
    sprintf( _sss, "Find %s: ", _nocase?"(no case)":"");
    SeeMsg( _sss );
    int ii = strlen(_sss)+1;
    _sss[0] = 0;
    if (seeopt.SeeLastFindStr[0] != 0) strcpy( _sss, seeopt.SeeLastFindStr+1 );
    if(!TextInput( ii, MAXY, "", MAXX-ii-2, MAXX-ii-2, _sss ))
      {
      SeeDraw();
      return 1;
      }
    seeopt.SeeLastFindStr[0] = fch;
    strcpy( seeopt.SeeLastFindStr+1, _sss );
    nocase = _nocase;
    SeeFindNext();
    return 0;
  }

  //////////////////////////////////////////////////////////////////////////
  void SeeHexEdit()
  {
    if (!seeopt.HEX)
      {
      SeeMsg( "HexEdit is available only in HEX mode :)" );
      return;
      }

    int TEXT = 0; // if text is edited
    int editbs = ROWS * 16;
    unsigned char *editb = (unsigned char*)malloc( editbs );
    fseek( SFF, SFPOS, SEEK_SET );
    editbs = fread( editb, 1, editbs, SFF );
    if ( editbs == 0 )
      {
      free( editb );
      SeeMsg( "Nothing to edit or read error..." );
      return;
      };
    int epos = 0;
    int bytepos = 0; // first or second byte part? :)

    SeeMsg( "WARNING: HEX EDITING MODE! ENTER = SAVE, ESC = CANCEL, TAB = TOGGLE EDIT MODE !", SeeWRNColor );
    ConCShow();
    int key = 0;
    while(4)
      {
      if (TEXT)
        ConXY( 64 + epos % 16, 1 + epos / 16 );
      else
        ConXY( 12 + (epos%16)*3 + 2*(epos%16 > 7) + bytepos, 1 + epos / 16 );
      if (key == 0) key = ConGetch();
      if ( key == 27 ) break;
      if ( key == 13 )
        {
        // will commit changes -- file should be reopened for RW
        fclose( SFF );
        SFF = fopen( SFFN, "r+b" );
        fseek( SFF, SFPOS, SEEK_SET );
        int ress = fwrite( editb, 1, editbs, SFF );
        fclose( SFF );
        if (  ress != editbs )
          {
          sprintf( _sss, "Write error: %s (press a key)", strerror( errno ) );
          SeeMsg( _sss );
          ConBeep();
          ConGetch();
          }
        SFF = fopen( SFFN, "rb" );
        break;
        }
      switch( key )
        {
        case 9         : TEXT = !TEXT; break;
        case KEY_RIGHT : if (bytepos == 0 && !TEXT)
                           bytepos = 1;
                         else
                           if (epos < editbs - 1)
                             {
                             epos++;
                             if (!TEXT) bytepos = 0;
                             }
                         break;
        case KEY_LEFT  : if (bytepos == 1 && !TEXT )
                           bytepos = 0;
                         else
                           if (epos > 0)
                             {
                             epos--;
                             if (!TEXT) bytepos = 1;
                             }
                         break;
        case KEY_DOWN  : if ( epos + 16 <  editbs ) epos += 16; break;
        case KEY_UP    : if ( epos - 16 >= 0      ) epos -= 16; break;
        
        case KEY_HOME  : epos = epos - epos%16; bytepos = 0; break;
        case KEY_END   : epos = epos + (16 - epos%16 - 1);
                         if (epos >= editbs) epos = editbs - 1;
                         bytepos = 0;  break;
        }
      if ( !TEXT && key > 0 && key < 255 && strchr( HEXCHARS, toupper(key) ) )
        {
        int n = StrFind( HEXCHARS, toupper(key) );
        char tmp[2];
        tmp[0] = HEXCHARS[n]; tmp[1] = 0;
        ConPuts( tmp, chRED );
        if (bytepos == 0)
          {
          editb[epos] = (n << 4) + ( editb[epos] & 0x0F );
          }
        else
          {
          editb[epos] = (n     ) + ( editb[epos] & 0xF0 );
          }
        tmp[0] = editb[epos];
        SeeFilter( tmp, 1 );
        ConXY( 64 + epos % 16, 1 + epos / 16);
        ConPuts( tmp, chRED );
        key = KEY_RIGHT;
        }
      else
      if ( TEXT && key >= 32 && key < 255 )
        {
        char tmp[3];
        tmp[0] = key; tmp[1] = 0;
        ConPuts( tmp, chRED );
        ConXY( 12 + (epos%16)*3 + 2*(epos%16 > 7), 1 + epos / 16 );
        sprintf( tmp, "%02X", key );
        tmp[2] = 0;
        ConPuts( tmp, chRED );
        editb[epos] = key;
        key = KEY_RIGHT;
        }
      else
        key = 0;
      }
    ConCHide();
    free(editb);
    SeeDraw();
  };

  //////////////////////////////////////////////////////////////////////////
  void SeeHelp()
  {
    ConOut( 1, 1,
    "+-----------------------------------------------------------------------------+\n"
    "| See v2.0 Help Screen (c) Vladi Belperchinov-Shabanski <cade@biscom.net>     |\n"
    "|                                                                             |\n"
    "| Key       TextMode             HexMode            Compatibility             |\n"
    "| --------+--------------------+--------------------+------------------------ |\n"
    "| UpArrow | one line back      | 16 bytes back      | P     = Home            |\n"
    "| DnArrow | one line forward   | 16 bytes forward   | B     = PgUp            |\n"
    "| LtArrow | col -8 ( `.' `>' ) |  1 byte  back      | SPC   = PgDn            |\n"
    "| RtArrow | col +8 ( `,' `<' ) |  1 byte  forward   | ENTER = DnArrow         |\n"
    "| Home    | go to line 1       | go to byte 0       |                         |\n"
    "| End     | go to last line    | go to last byte    |                         |\n"
    "| Ctrl+E  | -'- (no line info) | go to last byte    | l -- BG DOS xlate (slow)|\n"
    "| PgUp/Dn | one page back/forw | one page back/forw | L -- BG WIN xlate (slow)|\n"
    "| --------+--------------------+--------------------+------------------------ |\n"
    "| TAB  -- swhitch between Text and Hex mode         | ESC   -- exit           |\n"
    "| 1..0 -- switch to slot 1 .. slot 10               | Alt+X -- exit           |\n"
    "| W w  -- wrap to screen width                      | -     -- exit           |\n"
    "| +    -- goto line/pos (+line/pos, -line/pos)      | d -- show dec.pos (HEX) |\n"
    "| I    -- edit! (only for HEX mode)                 | o -- show EOL's (TEXT)  |\n"
    "| F S  -- find string F=no-case, S=case-sense       | r -- show ruler (TEXT)  |\n"
    "| \\ /  -- find reg.exp \\=no-case, /=case-sense      | a -- filter backspaces  |\n"
    "| E    -- find hex pattern ( example: c1 e2 04 )    | t -- tab expansion      |\n"
    "| N F3 -- find next                                 | g G -- grid (HEX)       |\n"
    "+-----------------------------------------------------------------------------+"
     , cCYAN ); ConGetch(); SeeDraw();
  }
  
  //////////////////////////////////////////////////////////////////////////
  int See()
  {
    if (FC == 0)
      {
      ConPuts("See: All slots are empty... ");
      return 0;
      }

    //---------read see.options---
    String SOFile = GetRcDir( "see" );
    SOFile += "see.options";

    TSeeOptions tmp_seeopt;
    memset( &seeopt, 0, sizeof(seeopt) );
    if ( fload_crc32( SOFile, &tmp_seeopt, sizeof(tmp_seeopt) ) == 0 )
      memcpy( &seeopt, &tmp_seeopt, sizeof( seeopt ));
    //----------------------------
      
    int z;
    column = 0;
    SeeSetFile(0);
    int ch = 0;
    while(ch != 27)
      {
      ch = ConGetch();
      #ifndef _SEE_EXE_
      // suppose see is used as part of VFU
      if ( opt.AltArrowsNav && ch == KEY_RIGHT ) ch = 0;
      if ( opt.AltArrowsNav && ch == KEY_LEFT  ) break;
      #endif
      if (  ch == 27        || ch == '-'           || ch == 'q' ||
            ch == KEY_ALT_X || ch == KEY_BACKSPACE ) break;
      if (SFFS < 1) { SeeMsg( "Zero size file -- press ESC"); continue; }
      switch(ch)
        {
        case KEY_F1     :
        case 'h'        :
        case 'H'        : SeeHelp(); break;
        case KEY_UP     : SeeUp(); SeeDraw(); break;
        case 13         :
        case KEY_DOWN   : SeeDown(); SeeDraw(); break;
        case 'b'        :
        case 'B'        :
        case KEY_PPAGE  : for ( z = 0; z < ROWS; z++ ) SeeUp(); SeeDraw(); break;
        case ' '        :
        case KEY_NPAGE  : for ( z = 0; z < ROWS; z++ ) SeeDown(); SeeDraw(); break;
        case 'p'        :
        case 'P'        :
        case KEY_HOME   : if (SFPOS == 0) column = 0; else SeeHome(); SeeDraw(); break;
        case KEY_END    : SeeEnd();  SeeDraw(); break;
        case KEY_CTRL_E : SeeEnd2(); SeeDraw(); break;

        case '>'        :
        case '.'        :
        case KEY_RIGHT  : if (seeopt.HEX)
                            {
                            if (SFPOS < SFFS) SFPOS++;
                            SeeDraw();
                            }
                          else
                            {
                            if (column < WRAP-10)
                              {
                              column += (ch=='>')?1:8;
                              SeeDraw();
                              }
                            };
                          break;
        case '<'        :
        case ','        :
        case KEY_LEFT   :
                          if (seeopt.HEX)
                            {
                            if (SFPOS > 0) SFPOS--;
                            SeeDraw();
                            }
                          else
                            {
                            if (column > 0)
                              {
                              column -= (ch=='<')?1:8;
                              if (column < 0) column = 0;
                              SeeDraw();
                              }
                            };
                          break;
        case 9          : SeeSwitchHEX(); break;
        case 'g'        : if (seeopt.GRID == 0) seeopt.GRID = 1; else seeopt.GRID = 0; SeeDraw(); break;
        case 'G'        : if (seeopt.GRID == 0) seeopt.GRID = 2; else seeopt.GRID = 0; SeeDraw(); break;
        case 'W'        :
        case 'w'        : WRAP = (WRAP < BSIZE)? BSIZE : MAXX;
                          SeeDraw();
                          SeeMsg( (WRAP == MAXX)? " Wrap ON" : " Wrap OFF" );
                          break;
        case '0'        :
        case '1'        :
        case '2'        :
        case '3'        :
        case '4'        :
        case '5'        :
        case '6'        :
        case '7'        :
        case '8'        :
        case '9'        : if (ch == '0') ch = '9'+1; SeeSetFile( ch - '1' ); break;
        case 'l'        : XLAT = (XLAT == 1)?0:1; SeeDraw(); break;
        case 'L'        : XLAT = (XLAT == 2)?0:2; SeeDraw(); break;
        case 'f'        :
        case 'F'        : SeeFind( '\\', 1 ); break;
        case 's'        :
        case 'S'        : SeeFind( '\\', 0 ); break;
        case 'e'        :
        case 'E'        : SeeFind( '$', 0 ); break;
        case '\\'       : SeeFind( '~', 1 ); break;
        case '/'        : SeeFind( '~', 0 ); break;
        case KEY_F(3)   :
        case 'n'        :
        case 'N'        : SeeFindNext(); break;
        case '+'        : GoTo(); break;
        case 'd'        :
        case 'D'        : if (seeopt.HEX) { seeopt.decpos = !seeopt.decpos; SeeDraw(); } break;
        case 'o'        :
        case 'O'        : if (!seeopt.HEX) { seeopt.showeol = !seeopt.showeol; SeeDraw(); } break;
        case 'a'        :
        case 'A'        : if (!seeopt.HEX)
                            {
                            HandleBS = !HandleBS;
                            SeeDraw();
                            SeeMsg( HandleBS? " BackSpace handling ON" : " BackSpace handling OFF" );
                            }
                          break;
        case 't'        :
        case 'T'        : if (!seeopt.HEX)
                            {
                            HandleTAB = !HandleTAB;
                            SeeDraw();
                            SeeMsg( HandleTAB? " TAB expansion ON" : " TAB expansion OFF" );
                            }
                          break;
        case 'r'        :
        case 'R'        : if (!seeopt.HEX)
                            {
                            _sss[0] = 0;
                            z = 8;
                            while (z) { strcat(_sss, "---------|"); z--; }
                            ConOut( 1, 1, _sss, SeeSLColor );
                            }
                          break;
        case 'i'        :
        case 'I'        : SeeHexEdit(); break;
        }
      }
    SeeCloseAll();
    ConXY( 1, MAXY );
    //-----------write opt file---
    fsave_crc32( SOFile, &seeopt, sizeof( seeopt ) );
    //----------------------------
    
    return 0;
  }

#ifdef _SEE_EXE_
//////////////////////////////////////////////////////////////////////////
int main( int argc, char *argv[] )
{
  if (argc < 2)
    {
    printf( "usage: %s filename filename...\n", argv[0] );
    return 100;
    };

  ConInit();
  ConCHide();

//  SeeSLColor = chYELLOW;

  int z = 0;
  for ( z = 1; z < argc; z++ )
    SeeAddFile( argv[z] );
  See();

  ConCShow();
  ConDone();
  return 0;
}
#endif
