/*
 *
 * (c) Vladi Belperchinov-Shabanski "Cade" <cade@biscom.net> 1996-1999
 *
 * SEE `README',`LICENSE' OR `COPYING' FILE FOR LICENSE AND OTHER DETAILS!
 *
 */

#include "vfumenu.h"
#include "vfucopy.h"
#include "vfuview.h"
#include "vfufiles.h"
#include "vfutools.h"

  void GetClassifyStr( const char *fname, char ch, char *tmp )
  {
    tmp[0] = 0;
    if (ch == 'N')
      {
      FileName( fname, tmp );
      if (strlen(fname) == strlen(tmp)) strcat( tmp, ".---" );
      } else
    if (ch == 'E')
      {
      FileExt( fname, tmp );
      if (strlen(tmp) == 0) strcat( tmp, "---" );
      }
    else
      {
      FileName( fname, tmp );
      StrSLeft( tmp, ch - '0' );
      if (strlen(fname) == strlen(tmp)) strcat( tmp, ".---" );
      }
  }

  void Classify()
  {
    char tmp[128];
    int tl; // tmplen
    if ( SelCount == 0 )
      {
      say1( "Classify function works only on already selected files..." );
      return;
      }

    mb.freeall();
    mb.add("N Name");
    mb.add("E Ext");
    mb.add("1 First 1 letter");
    mb.add("2 First 2 letters");
    mb.add("3 First 3 letters");
    mb.add("4 First 4 letters");
    mb.add("5 First 5 letters");
    mb.add("6 First 6 letters");
    mb.add("7 First 7 letters");
    mb.add("8 First 8 letters");
    mb.add("9 First 9 letter");
    if (MenuBox( 50, 5, "Classify files by") == -1 ) return;
    char ch = MenuBoxExitCh;

    mb.freeall();
    int z;
    int i;
    for ( z = 0; z < FilesCount; z++ )
      {
      if (Files[z]->is_dir) continue;
      if (!Files[z]->sel  ) continue;
      GetClassifyStr( Files[z]->name, ch, tmp );
      tl = strlen( tmp );
      int found = 0;
      for ( i = 0; i < mb.count(); i++ )
        if ( PathNCmp( tmp, mb[i], tl ) == 0 ) { found = 1; break; }
      if (!found) mb.add(tmp);
      }
    for ( i = 0; i < mb.count(); i++ )
      {
      int res = mkdir( mb[i], S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH );
      if ( res && !DirExist( mb[i] ) )
        {
        DescribeErrno();
        sprintf( sss, "Cannot create directory: %s (press a key)", mb[i] );
        say1( sss );
        ConGetch();
        }
      }
    for ( z = 0; z < FilesCount; z++ )
      {
      if (Files[z]->is_dir) continue;
      if (!Files[z]->sel  ) continue;
      GetClassifyStr( Files[z]->name, ch, tmp );
      strcat( tmp, "/" );
      OverMode = omAsk;
      if(CopyFile( CPath, tmp, Files[z]->name, Files[z]->fname, Files[z]->size, cmMOVE ) && OverMode == omAbort ) break;
      }
    ReadFiles();
  }



  void RenameTools()
  {
    int z;
    int err;
    String newname;

    if ( FilesCount < 1 )
      { say1( "No files to rename... (Empty directory)" ); return; };
    if ( SelCount < 1 )
      { say1( "No files to rename... (You have to select required files)" ); return; };
  
    mb.freeall();
    mb.add( "1 README.TXT => readme.txt" );
    mb.add( "2 README.TXT => readme.TXT" );
    mb.add( "3 README.TXT => README.txt" );
    mb.add( "4 readme.txt => README.TXT" );
    mb.add( "5 readme.txt => README.txt" );
    mb.add( "6 readme.txt => readme.TXT" );
    mb.add( "S Sequential rename" );
    if (MenuBox( 50, 5, "Rename Tools" ) == -1) return;
    switch( MenuBoxExitCh )
      {
      case '1' :
      case '2' :
      case '3' :
      case '4' :
      case '5' :
      case '6' : err = 0;
                 for ( z = 0; z < FilesCount; z++ )
                   {
                   TF* fi = Files[z];
                   
                   if ( fi->is_dir ) continue;
                   if ( !fi->sel ) continue;
                   FilePath( fi->name, sss );
                   newname = sss;
                   FileName( fi->name, sss );
                   if (MenuBoxExitCh == '1' || MenuBoxExitCh == '2')
                     StrLowCase( sss );
                   if (MenuBoxExitCh == '4' || MenuBoxExitCh == '5')
                     StrUpCase( sss );
                   newname += sss;
                   FileExt( fi->name, sss );
                   if (MenuBoxExitCh == '1' || MenuBoxExitCh == '3')
                     StrLowCase( sss );
                   if (MenuBoxExitCh == '4' || MenuBoxExitCh == '6')
                     StrUpCase( sss );
                   if (strlen(sss) > 0)
                     {
                     newname += ".";
                     newname += sss;
                     }
                   if (access( newname, F_OK ))
                     {
                     if (rename( fi->name, newname ) == 0)
                       {
                       strcpy(fi->name, newname);
                       fi->fname = strrchr( fi->name, '/' );
                       if ( fi->fname ) fi->fname++; else fi->fname = fi->name;
                       RefreshView( z );
                       draw = 1;
                       }
                     else
                       err++;
                     }
                   else
                     err++;
                   }
                 sprintf( sss, "Rename complete (errors: %d)", err );
                 say1( sss );
                 break;
      
      }
  };

 // eof vfutools.cpp
