/* Bluefish HTML Editor
 * configure.c
 *
 * Copyright (C) 1999 Olivier Sessink
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include <gtk/gtk.h>
#include <string.h>

#include <locale.h>
#include <libintl.h>
#define _(STRING) gettext(STRING)

#include "config.h"
#include "bluefish.h"
#include "init.h"
#include "gtk_easy.h"
#include "debug.h"
#include "interface.h"

GtkWidget *font_e, *browser_e, *weblint_e, *tabfont_e, *tabpos_c;
GtkWidget *width_s, *height_s, *tab_s, *thumbtype_c, *thumbstring_e;
GtkWidget *full_li_c, *full_p_c, *lowercase_tags_c;

void apply_config (GtkWidget * button, gpointer entry);

/*************************
 * 
 * start of functions
 *
 *************************/

GtkWidget *
string_entry2 (gchar * labeltext, gchar * which_config_string, GtkWidget * box)
{

  GtkWidget *label, *return_widget;

  label = gtk_label_new (labeltext);
  return_widget = gtk_entry_new ();
  gtk_entry_set_text (GTK_ENTRY (return_widget), which_config_string);
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 3);
  gtk_box_pack_start (GTK_BOX (box), return_widget, FALSE, FALSE, 3);
  return return_widget;
}

GtkWidget *
combo_entry2 (gchar * labeltext, gchar * which_config_string, GtkWidget * box, GList * poplist)
{

  GtkWidget *label, *return_widget;

  label = gtk_label_new (labeltext);
  return_widget = gtk_combo_new ();
  gtk_entry_set_editable (GTK_ENTRY (GTK_COMBO (return_widget)->entry), FALSE);
  gtk_combo_set_popdown_strings (GTK_COMBO (return_widget), poplist);
  g_list_free (poplist);

  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (return_widget)->entry), which_config_string);
  gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 3);
  gtk_box_pack_start (GTK_BOX (box), return_widget, FALSE, FALSE, 3);
  return return_widget;
}

GtkWidget *
check_entry2(gchar *labeltext, gint which_config_int, GtkWidget *box) {
  GtkWidget *return_widget;
  
  return_widget = gtk_check_button_new_with_label(labeltext);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(return_widget), which_config_int);
  gtk_box_pack_start (GTK_BOX (box), return_widget, FALSE, FALSE, 3);
  return return_widget;
}

/*
 */
static void
apply_choose_font (GtkWidget *widget, gpointer data)
{
gchar	*font;
  font = gtk_font_selection_dialog_get_font_name (GTK_FONT_SELECTION_DIALOG(data));
  DEBUG_MSG ("font=%s\n", font);
  /* FIXME: emit signal to entry here or not? */
  gtk_entry_set_text(GTK_ENTRY(font_e), font);
  g_free (font);
};

/*
 */
static void
ok_choose_font (GtkWidget *widget, gpointer data)
{
	/* FIXME: Or more rigth ue any emit* function */
	apply_choose_font (widget, data);
	gtk_grab_remove (GTK_WIDGET(data));
	gtk_widget_destroy (GTK_WIDGET(data));
};

/*
 */
static void
delete_choose_font (GtkWidget *widget, GdkEventAny *event, gpointer data)
{
	DEBUG_MSG ("data=%p\n", data);
	gtk_grab_remove (GTK_WIDGET(data));
	gtk_widget_destroy (GTK_WIDGET(data));
};

/*
 */
static void
close_choose_font (GtkWidget *widget, gpointer data)
{
	/* FIXME: Or more right use any emit* function? */
	delete_choose_font (widget, NULL, data);
};

/*
 * Function: choose_font
 * Arguments:
 * 	widget	- called widget
 * 	data	- pointer to entry widget
 * Return value:
 * 	void
 * Desciption:
 * 	Callback function for calling GtkFontSelection and install
 * 	choosed font string in entry 8-)
 */
static void
choose_font (GtkWidget *widget, gpointer data)
{
  GtkWidget *font_dialog;
  gchar	*font;

  font_dialog = gtk_font_selection_dialog_new (_("Font Selection"));

  /* Set font in font selection dialog */
  font = gtk_entry_get_text (GTK_ENTRY (data));
  gtk_font_selection_dialog_set_font_name (GTK_FONT_SELECTION_DIALOG (font_dialog),
		  font);
  g_free (font);

  /* connect all needing signals */
  gtk_signal_connect (GTK_OBJECT (GTK_FONT_SELECTION_DIALOG(font_dialog)->ok_button),
		  "clicked",
		  GTK_SIGNAL_FUNC (ok_choose_font),
		  (gpointer)font_dialog);
  
  gtk_signal_connect (GTK_OBJECT (GTK_FONT_SELECTION_DIALOG(font_dialog)->apply_button),
		  "clicked",
		  GTK_SIGNAL_FUNC (apply_choose_font),
		  (gpointer)font_dialog);

  gtk_signal_connect (GTK_OBJECT (GTK_FONT_SELECTION_DIALOG(font_dialog)->cancel_button),
		  "clicked",
		  GTK_SIGNAL_FUNC (close_choose_font),
		  (gpointer)font_dialog);

  gtk_signal_connect (GTK_OBJECT (font_dialog),
		  "delete_event",
		  GTK_SIGNAL_FUNC (delete_choose_font),
		  (gpointer)font_dialog);

  DEBUG_MSG ("font_dialog=%p\n", font_dialog);
  gtk_widget_show_all (font_dialog);

  /* make modal */
  gtk_grab_add (font_dialog);
};

void
configure (GtkWidget * widget, gpointer data)
{
  /* This is the callback function for a configure button */

  /* This configuration dialog is simplistic and will probably need
     a rewrite. */

  /* declare the widgets */
  GtkWidget *dialog, *frame;
  GtkWidget *ok;
  GtkWidget *cancel;
  GtkWidget *vbox, *hbox;
  GtkWidget *label, *notebook;
  GtkWidget *font_b;
  GtkObject *adjust;
  GList *poplist = NULL;

  /* create the widgets */
  DEBUG_MSG ("configure, started\n");
  dialog = gtk_dialog_new ();
  gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
		      GTK_SIGNAL_FUNC (gtk_main_quit), NULL);
  gtk_signal_connect (GTK_OBJECT (dialog), "destroy", GTK_SIGNAL_FUNC
		      (gtk_main_quit), NULL);
  /* give the dialog a name */
  gtk_window_set_title (GTK_WINDOW (dialog), _("Bluefish configuration"));
  gtk_container_border_width (GTK_CONTAINER (dialog), 5);

  notebook = gtk_notebook_new ();
  gtk_notebook_set_homogeneous_tabs(GTK_NOTEBOOK(notebook), TRUE);
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (notebook), GTK_POS_BOTTOM);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), notebook, TRUE,
		      TRUE, 0);

  /* editor */
  frame = gtk_frame_new (_("Editor options"));
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);
   hbox = gtk_hbox_new (FALSE, 0);
   font_e = string_entry2 (_("Default fontset"), cfg_editor_font, hbox);
   font_b = gtk_button_new_with_label (_("Fontset..."));
   gtk_signal_connect (GTK_OBJECT (font_b), "clicked",
 		      GTK_SIGNAL_FUNC (choose_font), font_e);
   gtk_box_pack_start (GTK_BOX (hbox), font_b,
 		      TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 3);
  label = gtk_label_new (_("Tab width"));
  adjust = gtk_adjustment_new (1.0 * cfg_editor_tabwidth, 1, 20, 1, 1, 0);
  tab_s = gtk_spin_button_new (GTK_ADJUSTMENT (adjust), 0.1, 0);
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 3);
  gtk_box_pack_start (GTK_BOX (vbox), tab_s, FALSE, FALSE, 3);
  full_li_c = check_entry2(_("Insert closing list-item tag </LI>"), full_li, vbox);
  full_p_c = check_entry2(_("Insert closing paragraph tag </P>"), full_p, vbox);
  lowercase_tags_c = check_entry2(_("Insert lowercase HTML tags"), lowercase_tags, vbox);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, gtk_label_new (_("Editor")));

  /* main GUI */
  frame = gtk_frame_new (_("Main GUI options"));
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);

  tabfont_e = string_entry2 (_("Notebook tab fontset"), cfg_tab_font, vbox);

  poplist = NULL;
  poplist = g_list_append (poplist, "top");
  poplist = g_list_append (poplist, "bottom");
  poplist = g_list_append (poplist, "left");
  poplist = g_list_append (poplist, "right");

  tabpos_c = combo_entry2 (_("Notebook position"), cfg_tab_pos, vbox, poplist);

  label = gtk_label_new (_("Initial width"));
  adjust = gtk_adjustment_new (1.0 * main_window_w, 50, 2000, 5, 25, 0);
  width_s = gtk_spin_button_new (GTK_ADJUSTMENT (adjust), 0.1, 0);
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 3);
  gtk_box_pack_start (GTK_BOX (vbox), width_s, FALSE, FALSE, 3);

  label = gtk_label_new (_("Initial height"));
  adjust = gtk_adjustment_new (1.0 * main_window_h, 50, 2000, 5, 25, 0);
  height_s = gtk_spin_button_new (GTK_ADJUSTMENT (adjust), 0.1, 0);
  gtk_box_pack_start (GTK_BOX (vbox), label, FALSE, FALSE, 3);
  gtk_box_pack_start (GTK_BOX (vbox), height_s, FALSE, FALSE, 3);

  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, gtk_label_new (_("GUI")));

  /* image dialog */
  frame = gtk_frame_new (_("Image dialog options"));
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);

  poplist = NULL;
  poplist = g_list_append (poplist, "png");
  poplist = g_list_append (poplist, "jpg");
  poplist = g_list_append (poplist, "gif");
  thumbtype_c = combo_entry2 (_("Thumbnail type"), cfg_thumbnailtype, vbox, poplist);

  thumbstring_e = string_entry2 (_("Thumbnail extension string"), cfg_thumbnailstring, vbox);

  label = gtk_label_new (_("Image dialog"));
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

  /* external programs */
  frame = gtk_frame_new (_("External program options"));
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);

  browser_e = string_entry2 (_("Browser command"), cfg_browser_cline, vbox);
  weblint_e = string_entry2 (_("Weblint command"), cfg_weblint_cline, vbox);

  label = gtk_label_new (_("External"));
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), frame, label);

  ok = bf_stock_button (_(" Save & close "), GTK_SIGNAL_FUNC (apply_config), dialog);
  cancel = bf_stock_cancel_button (GTK_SIGNAL_FUNC (gtk_main_quit), NULL);

  
  /* pack the widgets */
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->action_area), ok,
		      TRUE, TRUE, 0);
  gtk_box_pack_end (GTK_BOX (GTK_DIALOG (dialog)->action_area), cancel,
		    TRUE, TRUE, 0);

  /* show the widgets */
  gtk_widget_show_all (dialog);

  gtk_grab_add (dialog);
  gtk_main ();
  gtk_grab_remove (dialog);

  gtk_object_destroy (GTK_OBJECT (dialog));

  gtk_main ();
}

void
string_apply (gchar ** config_var, GtkWidget * entry)
{
  gchar *tmpstring;

  tmpstring = gtk_entry_get_text (GTK_ENTRY (entry));
  DEBUG_MSG ("string_apply, tmpstring=%s\n", tmpstring);
  if (config_var != NULL)
    {
      g_free (*config_var);
    }
  *config_var = g_strdup (tmpstring);
}

void
integer_apply (gint * config_var, GtkWidget * spinbutton)
{

  *config_var = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spinbutton));
}

void check_apply(gint *config_var, GtkWidget *check_button) {

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button))) {
    *config_var = 1;
  } else {
    *config_var = 0;
  }
}


void
apply_config (GtkWidget * button, gpointer entry)
{
  GList *tmplist;
  filestruct *tmpdoc;
  GdkFont *tmpfont;
  GtkStyle *style;

  statusbar_message (_("Saving and applying configuration"), 1000);
  string_apply (&cfg_browser_cline, browser_e);
  string_apply (&cfg_weblint_cline, weblint_e);
  string_apply (&cfg_editor_font, font_e);
  string_apply (&cfg_tab_font, tabfont_e);
  string_apply (&cfg_tab_pos, GTK_COMBO (tabpos_c)->entry);
  string_apply (&cfg_thumbnailtype, GTK_COMBO (thumbtype_c)->entry);
  string_apply (&cfg_thumbnailstring, thumbstring_e);
  integer_apply (&main_window_w, width_s);
  integer_apply (&main_window_h, height_s);
  integer_apply (&cfg_editor_tabwidth, tab_s);
  check_apply (&full_p, full_p_c);
  check_apply (&full_li, full_li_c);
  check_apply (&lowercase_tags, lowercase_tags_c);
  gtk_main_quit ();
  save_config_files ();

  /* actually try to apply these config values */
  gtk_window_set_policy (GTK_WINDOW (main_v->main_window), FALSE, FALSE, FALSE);
  gtk_widget_set_usize (GTK_WIDGET (main_v->main_window), main_window_w, main_window_h);
  gtk_window_set_policy (GTK_WINDOW (main_v->main_window), TRUE, TRUE, FALSE);
  tmplist = g_list_first (main_v->documentlist);
  while (tmplist)
    {
      tmpdoc = (filestruct *) tmplist->data;
      if (tmpdoc)
	{
	  style = gtk_style_new ();
	  tmpfont = style->font;

	  style->font = gdk_fontset_load (cfg_tab_font);
	  if (style->font)
	    {
	      gdk_font_unref (tmpfont);
	      gtk_widget_push_style (style);
	      gtk_widget_set_style (GTK_WIDGET (tmpdoc->tab_label), style);
	      gtk_widget_pop_style ();
	      DEBUG_MSG ("apply_config, tab style applied\n");
	    }
	  else
	    {
	      DEBUG_MSG ("apply_config, font = NULL, cfg_editor_font=%s\n", cfg_editor_font);
	      style->font = tmpfont;
	      gtk_style_unref (style);
	    }

	  style = gtk_style_new ();
	  tmpfont = style->font;

	  style->font = gdk_fontset_load (cfg_editor_font);
	  if (style->font)
	    {
	      gdk_font_unref (tmpfont);
	      gtk_widget_push_style (style);
	      gtk_widget_set_style (GTK_WIDGET (tmpdoc->textbox), style);
	      gtk_widget_pop_style ();
	      DEBUG_MSG ("apply_config, textbox style applied\n");
	    }
	  else
	    {
	      style->font = tmpfont;
	      gtk_style_unref (style);
	    }

	  GTK_TEXT (tmpdoc->textbox)->default_tab_width = cfg_editor_tabwidth;
	}			/* if (tmpdoc) */
      tmplist = g_list_next (tmplist);
    }

  if (strcmp (cfg_tab_pos, "left") == 0)
    {
      gtk_notebook_set_tab_pos (GTK_NOTEBOOK (main_v->notebook), GTK_POS_LEFT);
    }
  else if (strcmp (cfg_tab_pos, "right") == 0)
    {
      gtk_notebook_set_tab_pos (GTK_NOTEBOOK (main_v->notebook), GTK_POS_RIGHT);
    }
  else if (strcmp (cfg_tab_pos, "top") == 0)
    {
      gtk_notebook_set_tab_pos (GTK_NOTEBOOK (main_v->notebook), GTK_POS_TOP);
    }
  else
    {
      gtk_notebook_set_tab_pos (GTK_NOTEBOOK (main_v->notebook), GTK_POS_BOTTOM);
    }
  statusbar_message (_("Configuration saved and applied succesfully"), 1000);
  DEBUG_MSG ("apply_config, finished applying config values\n");
}
