/* Bluefish HTML Editor
 * html.h - menu/toolbar callback prototypes
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __HTML_H_
#define __HTML_H_

typedef struct {
	gchar *item;
	gchar *value;
} Ttagitem;

typedef struct {
	GList *taglist;
	gint pos;
	gint len;
} Ttagpopup;


typedef struct {
	gint pos;
	gint len;
} Treplacerange;

extern Treplacerange *values_for_dialog(gchar *dialogitems[], gchar *dialogvalues[], gchar **custom, Ttagpopup *data);
extern void parse_integer_for_dialog(gchar *valuestring, GtkWidget *spin, GtkWidget *entry, GtkWidget *checkbox);
extern void init_values_for_dialog(gchar *dialogitems[], gchar *dialogvalues[]);
extern void parse_integer_for_dialog(gchar *valuestring, GtkWidget *spin, GtkWidget *entry, GtkWidget *checkbox);
extern void  parse_existence_for_dialog(gchar *valuestring ,GtkWidget *checkbox);
extern gchar *insert_integer_if_spin(GtkWidget *spin, gchar *itemname, gchar *string2add2, GtkWidget *percentage);
extern gchar *insert_string_if_entry(GtkWidget *entry, gchar *itemname, gchar *string2add2);
extern void general_html (GtkWidget * widget, gpointer data);
extern void dtd(GtkWidget * widget, gpointer data);
extern void head(GtkWidget * widget, gpointer data);
extern void body (GtkWidget * widget, gpointer data);
extern void quickanchor (GtkWidget * widget, gpointer data);
extern void quickrule (GtkWidget * widget, gpointer data);
extern void email (GtkWidget * widget, gpointer data);
extern void fontdialog (GtkWidget * widget, gpointer data);
extern void basefont (GtkWidget * widget, gpointer data);
extern void tabledialog (GtkWidget * widget, gpointer data);
extern void tablerowdialog (GtkWidget * widget, gpointer data);
extern void tableheaderdialog (GtkWidget * widget, gpointer data);
extern void tabledatadialog (GtkWidget * widget, gpointer data);
extern void framesetdialog (GtkWidget * widget, gpointer data);
extern void framedialog (GtkWidget * widget, gpointer data);
extern void formdialog (GtkWidget * widget, gpointer data);
extern void submitdialog (GtkWidget * widget, gpointer data);
extern void resetdialog (GtkWidget * widget, gpointer data);
extern void textdialog (GtkWidget * widget, gpointer data);
extern void hiddendialog (GtkWidget * widget, gpointer data);
extern void textareadialog (GtkWidget * widget, gpointer data);
extern void radiodialog (GtkWidget * widget, gpointer data);
extern void checkdialog (GtkWidget * widget, gpointer data);
extern void selectdialog (GtkWidget * widget, gpointer data);
extern void quicklist (GtkWidget * widget, gpointer data);
extern void meta (GtkWidget * widget, gpointer data);
extern void embed (GtkWidget * widget, gpointer data);
extern void sel_colour (GtkWidget * widget, gpointer data);
extern void insert_time (GtkWidget * widget, gpointer data);

extern void create_buttons (GtkSignalFunc ok_func, gpointer ok_data);

/* color select button function */
extern GtkWidget *color_but_new (GtkWidget * which_entry, GtkWidget * win);
/* file select button function */
extern GtkWidget *file_but_new (GtkWidget * which_entry, GtkWidget * win, gint full_pathname);

#endif	/* __HTML_H_ */

