// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: window.cc,v 1.5 1998/09/15 05:57:25 jgg Exp $
/* ######################################################################

   GUIWindow - GUI Window widget
   
   Doesn't do much yet..
   
   ##################################################################### */
									/*}}}*/
// Include Files							/*{{{*/
#ifdef __GNUG__
#pragma implementation "deity/window.h"
#endif  
#include <deity/window.h>
									/*}}}*/

void *GUIWindow::Type = (void *)&GUIWindow::Type;

// GUIWindow::GUIWindow - Constructor					/*{{{*/
// ---------------------------------------------------------------------
/* */
GUIWindow::GUIWindow(string Title,Widget *Parent) : 
           BasicWidget(Parent == 0?Widget::Root:Parent), iTitle(Title)
{
   Flag(Region | Window);
   if (TextGC::GC != 0)
      Resize(Rect(0,0,40,10));
   else
      Resize(Rect(0,0,400,100));
   BorderWidth(0);
}
									/*}}}*/
// GUIWindow::Realize - Realize the window and set the title		/*{{{*/
// ---------------------------------------------------------------------
/* */
void GUIWindow::Realize()
{
   BasicWidget::Realize();
   GenGC::GC->SetTitle(RegionData,iTitle.c_str());
   if (IsFlag(Region) == false)
      BorderWidth(1);
}
									/*}}}*/
// GUIWindow::Render - Draw the widget									/*{{{*/
// ---------------------------------------------------------------------
/* */
void GUIWindow::Render(CombinedGC &GC) 
{
   BasicRender(GC,true);

   if (BorderY == 0)
       return;
   GC->DrawString(Point(Pos.w/2,0),iTitle,GenGC::XCenter | GenGC::YTop);
};
									/*}}}*/
// GUIWindow::Describe - Print a summary of the widget to a stream	/*{{{*/
// ---------------------------------------------------------------------
/* */
void GUIWindow::Describe(ostream &stream) const
{
   Widget::Describe(stream);
   stream << "GUIWindow(" << iTitle << ')';
}
									/*}}}*/
